/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.SimpleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InputExtractor {
    private final Metadata metadata;

    public InputExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public List<Input> extract(PlanNode root) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        root.accept(new Visitor((ImmutableSetMultimap.Builder<TableEntry, Column>)builder), null);
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        for (Map.Entry entry : builder.build().asMap().entrySet()) {
            Input input = new Input(((TableEntry)entry.getKey()).getConnectorId(), ((TableEntry)entry.getKey()).getSchema(), ((TableEntry)entry.getKey()).getTable(), (List<Column>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            inputBuilder.add((Object)input);
        }
        return inputBuilder.build();
    }

    private static final class TableEntry {
        private final String connectorId;
        private final String schema;
        private final String table;

        private TableEntry(String connectorId, String schema, String table) {
            this.connectorId = connectorId;
            this.schema = schema;
            this.table = table;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.schema, this.table);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TableEntry other = (TableEntry)obj;
            return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table);
        }
    }

    private class Visitor
    extends PlanVisitor<Void, Void> {
        private final ImmutableSetMultimap.Builder<TableEntry, Column> builder;

        public Visitor(ImmutableSetMultimap.Builder<TableEntry, Column> builder) {
            this.builder = builder;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle tableHandle = node.getTable();
            TableMetadata table = InputExtractor.this.metadata.getTableMetadata(tableHandle);
            SchemaTableName schemaTable = table.getTable();
            TableEntry entry = new TableEntry(table.getConnectorId(), schemaTable.getSchemaName(), schemaTable.getTableName());
            Optional<ColumnHandle> sampleWeightColumn = InputExtractor.this.metadata.getSampleWeightColumnHandle(tableHandle);
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                if (columnHandle.equals(sampleWeightColumn.orNull())) continue;
                ColumnMetadata columnMetadata = InputExtractor.this.metadata.getColumnMetadata(tableHandle, columnHandle);
                this.builder.put((Object)entry, (Object)new Column(columnMetadata.getName(), columnMetadata.getType().toString(), (Optional<SimpleDomain>)Optional.absent()));
            }
            return null;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }
    }
}

