/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.block.BlockBuilder;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import io.airlift.slice.Slice;
import java.util.Map;

public class InterpretedProjectionFunction
implements ProjectionFunction {
    private final Type type;
    private final ExpressionInterpreter evaluator;

    public InterpretedProjectionFunction(Type type, Expression expression, Map<Symbol, Input> symbolToInputMapping, Metadata metadata, Session session) {
        this.type = type;
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new SymbolToInputRewriter(symbolToInputMapping), (Expression)expression);
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session);
    }

    @Override
    public TupleInfo getTupleInfo() {
        return new TupleInfo(this.type.getRawType());
    }

    @Override
    public void project(TupleReadable[] cursors, BlockBuilder output) {
        Object value = this.evaluator.evaluate(cursors);
        this.append(output, value);
    }

    @Override
    public void project(RecordCursor cursor, BlockBuilder output) {
        Object value = this.evaluator.evaluate(cursor);
        this.append(output, value);
    }

    private void append(BlockBuilder output, Object value) {
        if (value == null) {
            output.appendNull();
        } else {
            switch (this.type) {
                case BOOLEAN: {
                    output.append((Boolean)value);
                    break;
                }
                case BIGINT: {
                    output.append((Long)value);
                    break;
                }
                case DOUBLE: {
                    output.append((Double)value);
                    break;
                }
                case VARCHAR: {
                    output.append((Slice)value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)this.type));
                }
            }
        }
    }
}

