/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.util.ThreadLocalCache;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import io.airlift.slice.Slice;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Regex;
import org.joni.Syntax;

public final class LikeUtils {
    private static final Syntax SYNTAX = new Syntax(0x800006, 0, 0, 0, new Syntax.MetaCharTable(92, 0, 0, 0, 0, 0));

    private LikeUtils() {
    }

    public static boolean dynamicLike(LikePatternCache callSiteCache, Slice value, Slice pattern, Slice escape) {
        LikeCacheKey key = new LikeCacheKey(pattern, escape);
        Regex regex = (Regex)callSiteCache.get(key);
        return LikeUtils.regexMatches(regex, value);
    }

    public static boolean regexMatches(Regex regex, Slice value) {
        byte[] bytes = value.getBytes();
        if (LikeUtils.isAscii(bytes)) {
            return LikeUtils.regexMatches(regex, bytes);
        }
        return LikeUtils.regexMatches(regex, value.toString(Charsets.UTF_8).getBytes(Charsets.UTF_8));
    }

    public static boolean regexMatches(Regex regex, byte[] bytes) {
        return regex.matcher(bytes).match(0, bytes.length, 0) != -1;
    }

    public static char getEscapeChar(Slice escape) {
        char escapeChar;
        String escapeString = escape.toString(Charsets.UTF_8);
        if (escapeString.length() == 0) {
            escapeChar = '\uffff';
        } else if (escapeString.length() == 1) {
            escapeChar = escapeString.charAt(0);
        } else {
            throw new IllegalArgumentException("escape must be empty or a single character: " + escapeString);
        }
        return escapeChar;
    }

    public static boolean isAscii(byte[] bytes) {
        boolean high = false;
        for (byte b : bytes) {
            high |= (b & 0x80) != 0;
        }
        return !high;
    }

    public static Regex likeToPattern(Slice pattern, @Nullable Slice escapeSlice) {
        String patternString = pattern.toString(Charsets.UTF_8);
        if (escapeSlice != null) {
            return LikeUtils.likeToPattern(patternString, LikeUtils.getEscapeChar(escapeSlice));
        }
        return LikeUtils.likeToPattern(patternString);
    }

    public static Regex likeToPattern(String patternString, char escapeChar) {
        return LikeUtils.likeToPattern(patternString, escapeChar, true);
    }

    public static Regex likeToPattern(String patternString) {
        return LikeUtils.likeToPattern(patternString, 'x', false);
    }

    private static Regex likeToPattern(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    if (escaped) {
                        regex.append("%");
                    } else {
                        regex.append(".*");
                    }
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    if (escaped) {
                        regex.append("_");
                    } else {
                        regex.append('.');
                    }
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '*': 
                        case '.': 
                        case '\\': 
                        case '^': {
                            regex.append('\\');
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        regex.append('$');
        byte[] bytes = regex.toString().getBytes(Charsets.UTF_8);
        return new Regex(bytes, 0, bytes.length, 0, (Encoding)UTF8Encoding.INSTANCE, SYNTAX);
    }

    public static class LikeCacheKey {
        private final Slice pattern;
        private final Slice escape;

        public LikeCacheKey(Slice pattern, Slice escape) {
            this.pattern = pattern;
            this.escape = escape;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.pattern, this.escape});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LikeCacheKey other = (LikeCacheKey)obj;
            return Objects.equal((Object)this.pattern, (Object)other.pattern) && Objects.equal((Object)this.escape, (Object)other.escape);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("pattern", (Object)this.pattern.toString(Charsets.UTF_8)).add("escape", (Object)this.escape.toString(Charsets.UTF_8)).toString();
        }
    }

    public static class LikePatternCache
    extends ThreadLocalCache<LikeCacheKey, Regex> {
        public LikePatternCache(int maxSizePerThread) {
            super(maxSizePerThread);
        }

        @Override
        @Nonnull
        protected Regex load(LikeCacheKey key) {
            return LikeUtils.likeToPattern(key.pattern, key.escape);
        }
    }
}

