/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanSanityChecker;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata) {
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.session = session;
        this.planOptimizers = planOptimizers;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public Plan plan(Analysis analysis) {
        RelationPlan plan;
        if (analysis.getCreateTableDestination().isPresent()) {
            plan = this.createTableWriterPlan(analysis);
        } else {
            RelationPlanner planner = new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
            plan = (RelationPlan)planner.process((Node)analysis.getQuery(), null);
        }
        PlanNode root = this.createOutputPlan(plan, analysis);
        PlanSanityChecker.validate(root);
        for (PlanOptimizer optimizer : this.planOptimizers) {
            root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator);
        }
        PlanSanityChecker.validate(root);
        return new Plan(root, this.symbolAllocator);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis) {
        QualifiedTableName destination = (QualifiedTableName)analysis.getCreateTableDestination().get();
        RelationPlanner planner = new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan plan = (RelationPlan)planner.process((Node)analysis.getQuery(), null);
        TableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getTableColumns(plan));
        ImmutableList writerOutputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", Type.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", Type.VARCHAR));
        TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), plan.getRoot(), null, plan.getOutputSymbols(), LogicalPlanner.getColumnNames(tableMetadata), (List<Symbol>)writerOutputs, (Optional<Symbol>)Optional.absent(), destination.getCatalogName(), tableMetadata, this.metadata.canCreateSampledTables(destination.getCatalogName()));
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", Type.BIGINT));
        TableCommitNode commitNode = new TableCommitNode(this.idAllocator.getNextId(), writerNode, null, (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getOutputDescriptor(), (List<Symbol>)outputs);
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (int i = 0; i < analysis.getOutputDescriptor().getFields().size(); ++i) {
            Field field = analysis.getOutputDescriptor().getFields().get(i);
            String name = (String)field.getName().or((Object)("_col" + i));
            names.add((Object)name);
            outputs.add((Object)plan.getSymbol(i));
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private TableMetadata createTableMetadata(QualifiedTableName table, List<ColumnMetadata> columns) {
        String owner = this.session.getUser();
        ConnectorTableMetadata metadata = new ConnectorTableMetadata(table.asSchemaTableName(), columns, owner);
        return new TableMetadata(table.getCatalogName(), metadata);
    }

    private static List<ColumnMetadata> getTableColumns(RelationPlan plan) {
        ImmutableList.Builder columns = ImmutableList.builder();
        List<Field> fields = plan.getDescriptor().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            String name = (String)field.getName().get();
            ColumnType type = field.getType().getColumnType();
            columns.add((Object)new ColumnMetadata(name, type, i, false));
        }
        return columns.build();
    }

    private static List<String> getColumnNames(TableMetadata tableMetadata) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            list.add((Object)column.getName());
        }
        return list.build();
    }
}

