/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.AnalyzerConfig;
import com.facebook.presto.sql.planner.optimizations.ImplementSampleAsFilter;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MaterializeSamplePullUp;
import com.facebook.presto.sql.planner.optimizations.MergeProjections;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneRedundantProjections;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.SimplifyExpressions;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import javax.inject.Provider;

public class PlanOptimizersFactory
implements Provider<List<PlanOptimizer>> {
    private final List<PlanOptimizer> optimizers;

    @Inject
    public PlanOptimizersFactory(Metadata metadata, SplitManager splitManager, AnalyzerConfig analyzerConfig) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new PlanOptimizer[]{new ImplementSampleAsFilter(), new SimplifyExpressions(metadata), new UnaliasSymbolReferences(), new PruneRedundantProjections(), new SetFlatteningOptimizer(), new MaterializeSamplePullUp(), new LimitPushDown(), new PredicatePushDown(metadata, splitManager, analyzerConfig.isExperimentalSyntaxEnabled()), new PredicatePushDown(metadata, splitManager, analyzerConfig.isExperimentalSyntaxEnabled()), new MergeProjections(), new SimplifyExpressions(metadata), new UnaliasSymbolReferences(), new PruneUnreferencedOutputs(), new PruneRedundantProjections()});
        this.optimizers = builder.build();
    }

    public synchronized List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

