/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.EquiJoinClause;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MaterializeSampleNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery;
        if (!node.getName().getPrefix().isPresent() && (namedQuery = this.analysis.getNamedQuery(node)) != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), subPlan.getOutputSymbols());
        }
        TupleDescriptor descriptor = this.analysis.getOutputDescriptor((Node)node);
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < descriptor.getFields().size(); ++i) {
            Field field = descriptor.getFields().get(i);
            Symbol symbol = this.symbolAllocator.newSymbol((String)field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList planOutputSymbols = outputSymbolsBuilder.build();
        Optional<ColumnHandle> sampleWeightColumn = this.metadata.getSampleWeightColumnHandle(handle);
        Symbol sampleWeightSymbol = null;
        if (sampleWeightColumn.isPresent()) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", Type.BIGINT);
            outputSymbolsBuilder.add((Object)sampleWeightSymbol);
            columns.put((Object)sampleWeightSymbol, sampleWeightColumn.get());
        }
        ImmutableList nodeOutputSymbols = outputSymbolsBuilder.build();
        PlanNode root = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)nodeOutputSymbols, (Map<Symbol, ColumnHandle>)columns.build(), null, (Optional<TableScanNode.GeneratedPartitions>)Optional.absent());
        if (sampleWeightSymbol != null) {
            root = new MaterializeSampleNode(this.idAllocator.getNextId(), root, sampleWeightSymbol);
        }
        return new RelationPlan(root, descriptor, (List<Symbol>)planOutputSymbols);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        return new RelationPlan(subPlan.getRoot(), outputDescriptor, subPlan.getOutputSymbols());
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        if (node.getColumnsToStratifyOn().isPresent()) {
            throw new UnsupportedOperationException("STRATIFY ON is not yet implemented");
        }
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        TupleDescriptor outputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        double ratio = this.analysis.getSampleRatio(node);
        Symbol sampleWeightSymbol = null;
        if (node.getType() == SampledRelation.Type.POISSONIZED) {
            sampleWeightSymbol = this.symbolAllocator.newSymbol("$sampleWeight", Type.BIGINT);
        }
        PlanNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType()), node.isRescaled(), (Optional<Symbol>)Optional.fromNullable((Object)sampleWeightSymbol));
        if (sampleWeightSymbol != null) {
            planNode = new MaterializeSampleNode(this.idAllocator.getNextId(), planNode, sampleWeightSymbol);
        }
        return new RelationPlan(planNode, outputDescriptor, subPlan.getOutputSymbols());
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getOutputSymbols()).addAll(rightPlan.getOutputSymbols()).build();
        if (node.getType() == Join.Type.CROSS) {
            return new RelationPlan(new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)ImmutableList.of()), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols);
        }
        List<EquiJoinClause> criteria = this.analysis.getJoinCriteria(node);
        Analysis.JoinInPredicates joinInPredicates = this.analysis.getJoinInPredicates(node);
        if (joinInPredicates != null) {
            leftPlanBuilder = this.appendSemiJoins(leftPlanBuilder, joinInPredicates.getLeftInPredicates());
            rightPlanBuilder = this.appendSemiJoins(rightPlanBuilder, joinInPredicates.getRightInPredicates());
        }
        leftPlanBuilder = this.appendProjections(leftPlanBuilder, Iterables.transform(criteria, EquiJoinClause.leftGetter()));
        rightPlanBuilder = this.appendProjections(rightPlanBuilder, Iterables.transform(criteria, EquiJoinClause.rightGetter()));
        ImmutableList.Builder clauses = ImmutableList.builder();
        for (EquiJoinClause clause : criteria) {
            Symbol leftSymbol = leftPlanBuilder.translate(clause.getLeft());
            Symbol rightSymbol = rightPlanBuilder.translate(clause.getRight());
            clauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
        }
        return new RelationPlan(new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)clauses.build()), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols);
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build());
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        PlanBuilder subPlan = (PlanBuilder)new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node, null);
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (FieldOrExpression fieldOrExpression : this.analysis.getOutputExpressions((Node)node)) {
            outputSymbols.add((Object)subPlan.translate(fieldOrExpression));
        }
        return new RelationPlan(subPlan.getRoot(), this.analysis.getOutputDescriptor((Node)node), (List<Symbol>)outputSymbols.build());
    }

    protected RelationPlan visitValues(Values node, Void context) {
        TupleDescriptor descriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (int i = 0; i < descriptor.getFields().size(); ++i) {
            Field field = descriptor.getFields().get(i);
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Row row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            for (Expression expression : row.getItems()) {
                values.add((Object)this.evaluateConstantExpression(expression));
            }
            rows.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbolsBuilder.build(), (List<List<Expression>>)rows.build());
        return new RelationPlan(valuesNode, descriptor, (List<Symbol>)outputSymbolsBuilder.build());
    }

    private Literal evaluateConstantExpression(final Expression expression) {
        try {
            ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session).optimize(new SymbolResolver(){

                @Override
                public Object getValue(Symbol symbol) {
                    throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)expression, "Constant expression cannot contain column references", new Object[0]);
                }
            });
            Object result = ExpressionInterpreter.expressionInterpreter(expression, this.metadata, this.session).evaluate(new TupleReadable[0]);
            Preconditions.checkState((!(result instanceof Expression) ? 1 : 0) != 0, (Object)"Expression interpreter returned an unresolved expression");
            return (Literal)LiteralInterpreter.toExpression(result);
        }
        catch (Exception e) {
            throw new SemanticException(SemanticErrorCode.EXPRESSION_NOT_CONSTANT, (Node)expression, "Error evaluating constant expression: %s", e.getMessage());
        }
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        List outputSymbols = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        for (Relation relation : node.getRelations()) {
            RelationPlan relationPlan = (RelationPlan)this.process((Node)relation, context);
            if (outputSymbols == null) {
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Symbol symbol : relationPlan.getOutputSymbols()) {
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                outputSymbols = outputSymbolBuilder.build();
            }
            for (int i = 0; i < outputSymbols.size(); ++i) {
                symbolMapping.put(outputSymbols.get(i), (Object)relationPlan.getOutputSymbols().get(i));
            }
            sources.add((Object)relationPlan.getRoot());
        }
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), (List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getOutputDescriptor((Node)node), planNode.getOutputSymbols());
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private PlanBuilder appendProjections(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getRoot().getOutputSymbols()) {
            QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)qualifiedNameReference);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()));
    }

    private PlanBuilder appendSemiJoins(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendSemiJoin(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendSemiJoin(PlanBuilder subPlan, InPredicate inPredicate) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        subPlan = this.appendProjections(subPlan, (Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()));
        Symbol sourceJoinSymbol = subPlan.translate(inPredicate.getValue());
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression subqueryExpression = (SubqueryExpression)inPredicate.getValueList();
        RelationPlanner relationPlanner = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan valueListRelation = (RelationPlan)relationPlanner.process((Node)subqueryExpression.getQuery(), null);
        Symbol filteringSourceJoinSymbol = (Symbol)Iterables.getOnlyElement(valueListRelation.getRoot().getOutputSymbols());
        Symbol semiJoinOutputSymbol = this.symbolAllocator.newSymbol("semijoinresult", Type.BOOLEAN);
        translations.put((Expression)inPredicate, semiJoinOutputSymbol);
        return new PlanBuilder(translations, new SemiJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutputSymbol));
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, node.getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), (Optional<Symbol>)Optional.absent(), 1.0);
    }
}

