/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.SplitSource;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class StageExecutionPlan {
    private final PlanFragment fragment;
    private final Optional<SplitSource> dataSource;
    private final List<StageExecutionPlan> subStages;
    private final List<TupleInfo> tupleInfos;
    private final Optional<List<String>> fieldNames;

    public StageExecutionPlan(PlanFragment fragment, Optional<SplitSource> dataSource, List<StageExecutionPlan> subStages) {
        this.fragment = (PlanFragment)Preconditions.checkNotNull((Object)fragment, (Object)"fragment is null");
        this.dataSource = (Optional)Preconditions.checkNotNull(dataSource, (Object)"dataSource is null");
        this.subStages = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(subStages, (Object)"dependencies is null")));
        this.tupleInfos = ImmutableList.copyOf(IterableTransformer.on(fragment.getRoot().getOutputSymbols()).transform(Functions.forMap(fragment.getSymbols())).transform(Type.toRaw()).transform(new Function<TupleInfo.Type, TupleInfo>(){

            public TupleInfo apply(TupleInfo.Type input) {
                return new TupleInfo(input);
            }
        }).list());
        this.fieldNames = fragment.getRoot() instanceof OutputNode ? Optional.of((Object)ImmutableList.copyOf(((OutputNode)fragment.getRoot()).getColumnNames())) : Optional.absent();
    }

    public List<TupleInfo> getTupleInfos() {
        return this.tupleInfos;
    }

    public List<String> getFieldNames() {
        Preconditions.checkState((boolean)this.fieldNames.isPresent(), (Object)"cannot get field names from non-output stage");
        return (List)this.fieldNames.get();
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public Optional<SplitSource> getDataSource() {
        return this.dataSource;
    }

    public List<StageExecutionPlan> getSubStages() {
        return this.subStages;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fragment", (Object)this.fragment).add("dataSource", this.dataSource).add("subStages", this.subStages).toString();
    }
}

