/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SubPlan {
    private final PlanFragment fragment;
    private final List<SubPlan> children;

    public SubPlan(PlanFragment fragment, List<SubPlan> children) {
        Preconditions.checkNotNull((Object)fragment, (Object)"fragment is null");
        Preconditions.checkNotNull(children, (Object)"children is null");
        this.fragment = fragment;
        this.children = ImmutableList.copyOf(children);
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public List<SubPlan> getChildren() {
        return this.children;
    }

    public List<PlanFragment> getAllFragments() {
        ImmutableList.Builder fragments = ImmutableList.builder();
        fragments.add((Object)this.getFragment());
        for (SubPlan child : this.getChildren()) {
            fragments.addAll(child.getAllFragments());
        }
        return fragments.build();
    }

    public void sanityCheck() {
        Multiset<PlanFragmentId> exchangeIds = IterableTransformer.on(this.fragment.getSources()).select((Predicate<PlanNode>)Predicates.instanceOf(ExchangeNode.class)).cast(ExchangeNode.class).transformAndFlatten(ExchangeNode.sourceFragmentIdsGetter()).bag();
        Multiset<PlanFragmentId> childrenIds = IterableTransformer.on(this.children).transform(SubPlan.fragmentGetter()).transform(PlanFragment.idGetter()).bag();
        Preconditions.checkState((boolean)exchangeIds.equals(childrenIds), (String)"Subplan exchange ids don't match child fragment ids (%s vs %s)", (Object[])new Object[]{exchangeIds, childrenIds});
        for (SubPlan child : this.children) {
            child.sanityCheck();
        }
    }

    public static Function<SubPlan, PlanFragment> fragmentGetter() {
        return new Function<SubPlan, PlanFragment>(){

            public PlanFragment apply(SubPlan input) {
                return input.getFragment();
            }
        };
    }
}

