/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.sql.analyzer.Session;
import com.facebook.presto.sql.analyzer.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MaterializeSampleNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MaterializeSamplePullUp
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(idAllocator, symbolAllocator), plan, null);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;

        private Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
            this.symbolAllocator = (SymbolAllocator)Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        }

        @Override
        public PlanNode rewriteNode(PlanNode node, Void context, PlanRewriter<Void> planRewriter) {
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteTableWriter(TableWriterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                Preconditions.checkArgument((boolean)node.isSampleWeightSupported(), (Object)"Cannot write sampled data to a store that doesn't support sampling");
                ConnectorTableMetadata connectorTableMetadata = node.getTableMetadata().getMetadata();
                connectorTableMetadata = new ConnectorTableMetadata(connectorTableMetadata.getTable(), connectorTableMetadata.getColumns(), connectorTableMetadata.getOwner(), true);
                return new TableWriterNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getTarget(), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), (Optional<Symbol>)Optional.of((Object)((MaterializeSampleNode)source).getSampleWeightSymbol()), node.getCatalog(), new TableMetadata(node.getTableMetadata().getConnectorId(), connectorTableMetadata), node.isSampleWeightSupported());
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteFilter(FilterNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode && DeterminismEvaluator.isDeterministic(node.getPredicate())) {
                FilterNode filterNode = new FilterNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getPredicate());
                return new MaterializeSampleNode(source.getId(), filterNode, ((MaterializeSampleNode)source).getSampleWeightSymbol());
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode && Iterables.all(node.getExpressions(), DeterminismEvaluator.deterministic())) {
                Symbol sampleWeightSymbol = ((MaterializeSampleNode)source).getSampleWeightSymbol();
                ImmutableMap outputMap = ImmutableMap.builder().putAll(node.getOutputMap()).put((Object)sampleWeightSymbol, (Object)new QualifiedNameReference(sampleWeightSymbol.toQualifiedName())).build();
                ProjectNode projectNode = new ProjectNode(node.getId(), ((MaterializeSampleNode)source).getSource(), (Map<Symbol, Expression>)outputMap);
                return new MaterializeSampleNode(source.getId(), projectNode, sampleWeightSymbol);
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteTopN(TopNNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                node = new TopNNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getCount(), node.getOrderBy(), node.getOrderings(), node.isPartial(), (Optional<Symbol>)Optional.of((Object)((MaterializeSampleNode)source).getSampleWeightSymbol()));
                return new MaterializeSampleNode(source.getId(), node, ((MaterializeSampleNode)source).getSampleWeightSymbol());
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteSort(SortNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                node = new SortNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getOrderBy(), node.getOrderings());
                return new MaterializeSampleNode(source.getId(), node, ((MaterializeSampleNode)source).getSampleWeightSymbol());
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteLimit(LimitNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                node = new LimitNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getCount(), (Optional<Symbol>)Optional.of((Object)((MaterializeSampleNode)source).getSampleWeightSymbol()));
                return new MaterializeSampleNode(source.getId(), node, ((MaterializeSampleNode)source).getSampleWeightSymbol());
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteDistinctLimit(DistinctLimitNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                ImmutableMap.Builder projections = ImmutableMap.builder();
                for (Symbol symbol : source.getOutputSymbols()) {
                    QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
                    projections.put((Object)symbol, (Object)expression);
                }
                source = new ProjectNode(this.idAllocator.getNextId(), ((MaterializeSampleNode)source).getSource(), (Map<Symbol, Expression>)projections.build());
                return new DistinctLimitNode(node.getId(), source, node.getLimit());
            }
            return new DistinctLimitNode(node.getId(), source, node.getLimit());
        }

        @Override
        public PlanNode rewriteMarkDistinct(MarkDistinctNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                node = new MarkDistinctNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getMarkerSymbol(), node.getDistinctSymbols(), (Optional<Symbol>)Optional.of((Object)((MaterializeSampleNode)source).getSampleWeightSymbol()));
                return new MaterializeSampleNode(source.getId(), node, ((MaterializeSampleNode)source).getSampleWeightSymbol());
            }
            return planRewriter.defaultRewrite(node, null);
        }

        @Override
        public PlanNode rewriteSemiJoin(SemiJoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode filteringSource = planRewriter.rewrite(node.getFilteringSource(), null);
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (filteringSource instanceof MaterializeSampleNode) {
                filteringSource = ((MaterializeSampleNode)filteringSource).getSource();
            }
            if (source instanceof MaterializeSampleNode) {
                node = new SemiJoinNode(node.getId(), ((MaterializeSampleNode)source).getSource(), filteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
                return new MaterializeSampleNode(source.getId(), node, ((MaterializeSampleNode)source).getSampleWeightSymbol());
            }
            return new SemiJoinNode(node.getId(), source, filteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), null);
            if (source instanceof MaterializeSampleNode) {
                if (node.getAggregations().isEmpty() && node.getOutputSymbols().size() == node.getGroupBy().size() && node.getOutputSymbols().containsAll(node.getGroupBy())) {
                    ImmutableMap.Builder projections = ImmutableMap.builder();
                    for (Symbol symbol : source.getOutputSymbols()) {
                        QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
                        projections.put((Object)symbol, (Object)expression);
                    }
                    source = new ProjectNode(this.idAllocator.getNextId(), ((MaterializeSampleNode)source).getSource(), (Map<Symbol, Expression>)projections.build());
                    return new AggregationNode(node.getId(), source, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), (Optional<Symbol>)Optional.absent(), node.getConfidence());
                }
                return new AggregationNode(node.getId(), ((MaterializeSampleNode)source).getSource(), node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), (Optional<Symbol>)Optional.of((Object)((MaterializeSampleNode)source).getSampleWeightSymbol()), node.getConfidence());
            }
            return new AggregationNode(node.getId(), source, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getSampleWeight(), node.getConfidence());
        }

        @Override
        public PlanNode rewriteJoin(JoinNode node, Void context, PlanRewriter<Void> planRewriter) {
            PlanNode leftSource = planRewriter.rewrite(node.getLeft(), null);
            PlanNode rightSource = planRewriter.rewrite(node.getRight(), null);
            if (leftSource instanceof MaterializeSampleNode || rightSource instanceof MaterializeSampleNode) {
                Symbol outputSampleWeight;
                Symbol leftSampleWeight = null;
                Symbol rightSampleWeight = null;
                if (leftSource instanceof MaterializeSampleNode) {
                    leftSampleWeight = ((MaterializeSampleNode)leftSource).getSampleWeightSymbol();
                    leftSource = ((MaterializeSampleNode)leftSource).getSource();
                }
                if (rightSource instanceof MaterializeSampleNode) {
                    rightSampleWeight = ((MaterializeSampleNode)rightSource).getSampleWeightSymbol();
                    rightSource = ((MaterializeSampleNode)rightSource).getSource();
                }
                PlanNode joinNode = new JoinNode(node.getId(), node.getType(), leftSource, rightSource, node.getCriteria());
                if (leftSampleWeight != null && rightSampleWeight != null) {
                    ArithmeticExpression sampleWeightExpr;
                    ImmutableMap.Builder projections = ImmutableMap.builder();
                    switch (node.getType()) {
                        case INNER: 
                        case CROSS: {
                            sampleWeightExpr = new ArithmeticExpression(ArithmeticExpression.Type.MULTIPLY, (Expression)new QualifiedNameReference(leftSampleWeight.toQualifiedName()), (Expression)new QualifiedNameReference(rightSampleWeight.toQualifiedName()));
                            break;
                        }
                        case LEFT: {
                            sampleWeightExpr = new ArithmeticExpression(ArithmeticExpression.Type.MULTIPLY, (Expression)new QualifiedNameReference(leftSampleWeight.toQualifiedName()), this.oneIfNull(rightSampleWeight));
                            break;
                        }
                        case RIGHT: {
                            sampleWeightExpr = new ArithmeticExpression(ArithmeticExpression.Type.MULTIPLY, this.oneIfNull(leftSampleWeight), (Expression)new QualifiedNameReference(rightSampleWeight.toQualifiedName()));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)String.format("Unknown join type: %s", new Object[]{node.getType()}));
                        }
                    }
                    outputSampleWeight = this.symbolAllocator.newSymbol((Expression)sampleWeightExpr, Type.BIGINT);
                    projections.put((Object)outputSampleWeight, (Object)sampleWeightExpr);
                    for (Symbol symbol : Iterables.filter(node.getOutputSymbols(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableSet.of((Object)leftSampleWeight, (Object)rightSampleWeight))))) {
                        QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
                        projections.put((Object)symbol, (Object)expression);
                    }
                    joinNode = new ProjectNode(this.idAllocator.getNextId(), joinNode, (Map<Symbol, Expression>)projections.build());
                } else {
                    Symbol symbol = outputSampleWeight = leftSampleWeight == null ? rightSampleWeight : leftSampleWeight;
                    if (node.getType() == JoinNode.Type.LEFT && leftSampleWeight == null || node.getType() == JoinNode.Type.RIGHT && rightSampleWeight == null) {
                        ImmutableMap.Builder projections = ImmutableMap.builder();
                        for (Symbol symbol2 : Iterables.filter(node.getOutputSymbols(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)outputSampleWeight)))) {
                            QualifiedNameReference expression = new QualifiedNameReference(symbol2.toQualifiedName());
                            projections.put((Object)symbol2, (Object)expression);
                        }
                        Expression sampleWeightExpr = this.oneIfNull(outputSampleWeight);
                        outputSampleWeight = this.symbolAllocator.newSymbol(sampleWeightExpr, Type.BIGINT);
                        projections.put((Object)outputSampleWeight, (Object)sampleWeightExpr);
                        joinNode = new ProjectNode(this.idAllocator.getNextId(), joinNode, (Map<Symbol, Expression>)projections.build());
                    }
                }
                return new MaterializeSampleNode(this.idAllocator.getNextId(), joinNode, outputSampleWeight);
            }
            return new JoinNode(node.getId(), node.getType(), leftSource, rightSource, node.getCriteria());
        }

        private Expression oneIfNull(Symbol symbol) {
            return new CoalesceExpression(new Expression[]{new QualifiedNameReference(symbol.toQualifiedName()), new LongLiteral("1")});
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, Void context, final PlanRewriter<Void> planRewriter) {
            List<PlanNode> rewrittenSources = IterableTransformer.on(node.getSources()).transform(new Function<PlanNode, PlanNode>(){

                public PlanNode apply(PlanNode input) {
                    return planRewriter.rewrite(input, null);
                }
            }).list();
            if (Iterables.all(rewrittenSources, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(MaterializeSampleNode.class)))) {
                return new UnionNode(node.getId(), rewrittenSources, node.getSymbolMapping());
            }
            ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder().putAll(node.getSymbolMapping());
            ImmutableList.Builder sources = ImmutableList.builder();
            Symbol outputSymbol = this.symbolAllocator.newSymbol("$sampleWeight", Type.BIGINT);
            for (PlanNode source : rewrittenSources) {
                if (source instanceof MaterializeSampleNode) {
                    symbolMapping.put((Object)outputSymbol, (Object)((MaterializeSampleNode)source).getSampleWeightSymbol());
                    sources.add((Object)((MaterializeSampleNode)source).getSource());
                    continue;
                }
                Symbol symbol = this.symbolAllocator.newSymbol("$sampleWeight", Type.BIGINT);
                symbolMapping.put((Object)outputSymbol, (Object)symbol);
                sources.add((Object)this.addSampleWeight(source, symbol));
            }
            node = new UnionNode(node.getId(), (List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
            return new MaterializeSampleNode(this.idAllocator.getNextId(), node, outputSymbol);
        }

        private PlanNode addSampleWeight(PlanNode source, Symbol sampleWeightSymbol) {
            ImmutableMap.Builder projections = ImmutableMap.builder();
            for (Symbol symbol : source.getOutputSymbols()) {
                QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
                projections.put((Object)symbol, (Object)expression);
            }
            LongLiteral one = new LongLiteral("1");
            projections.put((Object)sampleWeightSymbol, (Object)one);
            return new ProjectNode(this.idAllocator.getNextId(), source, (Map<Symbol, Expression>)projections.build());
        }
    }
}

