/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MaterializeSampleNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class PlanRewriter<C> {
    private final PlanNodeRewriter<C> nodeRewriter;
    private final PlanVisitor<Context<C>, PlanNode> visitor;

    public static <C, T extends PlanNode> T rewriteWith(PlanNodeRewriter<C> rewriter, T node) {
        return PlanRewriter.rewriteWith(rewriter, node, null);
    }

    public static <C, T extends PlanNode> T rewriteWith(PlanNodeRewriter<C> rewriter, T node, C context) {
        return new PlanRewriter<C>(rewriter).rewrite(node, context);
    }

    public PlanRewriter(PlanNodeRewriter<C> nodeRewriter) {
        this.nodeRewriter = nodeRewriter;
        this.visitor = new RewritingVisitor();
    }

    public <T extends PlanNode> T rewrite(T node, C context) {
        return (T)node.accept(this.visitor, new Context(context, false));
    }

    public <T extends PlanNode> T defaultRewrite(T node, C context) {
        return (T)node.accept(this.visitor, new Context(context, true));
    }

    public static <C, T extends PlanNode> Function<PlanNode, T> rewriteFunction(final PlanNodeRewriter<C> rewriter) {
        return new Function<PlanNode, T>(){

            public T apply(PlanNode node) {
                return PlanRewriter.rewriteWith(rewriter, node);
            }
        };
    }

    public static class Context<C> {
        private boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    extends PlanVisitor<Context<C>, PlanNode> {
        private RewritingVisitor() {
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteNode(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            throw new UnsupportedOperationException("not yet implemented: " + this.getClass().getSimpleName() + " for " + node.getClass().getName());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteExchange(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteAggregation(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new AggregationNode(node.getId(), source, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence());
            }
            return node;
        }

        @Override
        public PlanNode visitMaterializeSample(MaterializeSampleNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteMaterializeSample(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new MaterializeSampleNode(node.getId(), source, node.getSampleWeightSymbol());
            }
            return node;
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteMarkDistinct(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new MarkDistinctNode(node.getId(), source, node.getMarkerSymbol(), node.getDistinctSymbols(), node.getSampleWeightSymbol());
            }
            return node;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteWindow(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new WindowNode(node.getId(), source, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getWindowFunctions(), node.getSignatures());
            }
            return node;
        }

        @Override
        public PlanNode visitFilter(FilterNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteFilter(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new FilterNode(node.getId(), source, node.getPredicate());
            }
            return node;
        }

        @Override
        public PlanNode visitSample(SampleNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteSample(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new SampleNode(node.getId(), source, node.getSampleRatio(), node.getSampleType(), node.isRescaled(), node.getSampleWeightSymbol());
            }
            return node;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteProject(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new ProjectNode(node.getId(), source, node.getOutputMap());
            }
            return node;
        }

        @Override
        public PlanNode visitTopN(TopNNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteTopN(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new TopNNode(node.getId(), source, node.getCount(), node.getOrderBy(), node.getOrderings(), node.isPartial(), node.getSampleWeight());
            }
            return node;
        }

        @Override
        public PlanNode visitOutput(OutputNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteOutput(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new OutputNode(node.getId(), source, node.getColumnNames(), node.getOutputSymbols());
            }
            return node;
        }

        @Override
        public PlanNode visitLimit(LimitNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteLimit(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new LimitNode(node.getId(), source, node.getCount(), node.getSampleWeight());
            }
            return node;
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteDistinctLimit(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new DistinctLimitNode(node.getId(), source, node.getLimit());
            }
            return node;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteTableScan(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public PlanNode visitValues(ValuesNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteValues(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteTableWriter(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new TableWriterNode(node.getId(), source, node.getTarget(), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getSampleWeightSymbol(), node.getCatalog(), node.getTableMetadata(), node.isSampleWeightSupported());
            }
            return node;
        }

        @Override
        public PlanNode visitTableCommit(TableCommitNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteTableCommit(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new TableCommitNode(node.getId(), source, node.getTarget(), node.getOutputSymbols());
            }
            return node;
        }

        @Override
        public PlanNode visitJoin(JoinNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteJoin(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode left = PlanRewriter.this.rewrite(node.getLeft(), context.get());
            PlanNode right = PlanRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new JoinNode(node.getId(), node.getType(), left, right, node.getCriteria());
            }
            return node;
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteSemiJoin(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            PlanNode filteringSource = PlanRewriter.this.rewrite(node.getFilteringSource(), context.get());
            if (source != node.getSource() || filteringSource != node.getFilteringSource()) {
                return new SemiJoinNode(node.getId(), source, filteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
            }
            return node;
        }

        @Override
        public PlanNode visitSort(SortNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteSort(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            PlanNode source = PlanRewriter.this.rewrite(node.getSource(), context.get());
            if (source != node.getSource()) {
                return new SortNode(node.getId(), source, node.getOrderBy(), node.getOrderings());
            }
            return node;
        }

        @Override
        public PlanNode visitUnion(UnionNode node, Context<C> context) {
            PlanNode result;
            if (!context.isDefaultRewrite() && (result = PlanRewriter.this.nodeRewriter.rewriteUnion(node, context.get(), PlanRewriter.this)) != null) {
                return result;
            }
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (PlanNode subPlan : node.getSources()) {
                PlanNode rewriteSubPlan = PlanRewriter.this.rewrite(subPlan, context.get());
                if (rewriteSubPlan != subPlan) {
                    modified = true;
                }
                builder.add((Object)rewriteSubPlan);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List<PlanNode>)builder.build(), node.getSymbolMapping());
            }
            return node;
        }
    }
}

