/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.IterableTransformer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnionNode
extends PlanNode {
    private final List<PlanNode> sources;
    private final ImmutableListMultimap<Symbol, Symbol> symbolMapping;

    @JsonCreator
    public UnionNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="symbolMapping") ListMultimap<Symbol, Symbol> symbolMapping) {
        super(id);
        Preconditions.checkNotNull(sources, (Object)"sources is null");
        Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source");
        Preconditions.checkNotNull(symbolMapping, (Object)"symbolMapping is null");
        this.sources = ImmutableList.copyOf(sources);
        this.symbolMapping = ImmutableListMultimap.copyOf(symbolMapping);
        for (Collection symbols : this.symbolMapping.asMap().values()) {
            Preconditions.checkArgument((symbols.size() == this.sources.size() ? 1 : 0) != 0, (Object)"Every source needs to map its symbols to an output UNION symbol");
        }
        for (int i = 0; i < sources.size(); ++i) {
            for (Collection symbols : this.symbolMapping.asMap().values()) {
                Preconditions.checkArgument((boolean)sources.get(i).getOutputSymbols().contains(Iterables.get((Iterable)symbols, (int)i)), (Object)"Source does not provide required symbols");
            }
        }
    }

    @Override
    @JsonProperty(value="sources")
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Collection)this.symbolMapping.keySet());
    }

    @JsonProperty(value="symbolMapping")
    public ListMultimap<Symbol, Symbol> getSymbolMapping() {
        return this.symbolMapping;
    }

    public List<Symbol> sourceOutputLayout(int sourceIndex) {
        return IterableTransformer.on(this.getOutputSymbols()).transform(this.outputToSourceSymbolFunction(sourceIndex)).list();
    }

    public Map<Symbol, QualifiedNameReference> sourceSymbolMap(int sourceIndex) {
        return IterableTransformer.on(this.getOutputSymbols()).toMap(this.outputToSourceSymbolFunction(sourceIndex)).transformValues(ExpressionUtils.symbolToQualifiedNameReference()).immutableMap();
    }

    public Map<Symbol, QualifiedNameReference> outputSymbolMap(int sourceIndex) {
        return IterableTransformer.on(this.getOutputSymbols()).toMap(this.outputToSourceSymbolFunction(sourceIndex)).inverse().transformValues(ExpressionUtils.symbolToQualifiedNameReference()).immutableMap();
    }

    private Function<Symbol, Symbol> outputToSourceSymbolFunction(final int sourceIndex) {
        return new Function<Symbol, Symbol>(){

            public Symbol apply(Symbol outputSymbol) {
                return (Symbol)Iterables.get((Iterable)UnionNode.this.symbolMapping.get((Object)outputSymbol), (int)sourceIndex);
            }
        };
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitUnion(this, context);
    }
}

