/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.storage;

import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTableNameMapper;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface StorageDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS source_table (\n  source_table_id BIGINT PRIMARY KEY AUTO_INCREMENT,\n  table_id BIGINT NOT NULL,\n  catalog_name VARCHAR(255) NOT NULL,\n  schema_name VARCHAR(255) NOT NULL,\n  table_name VARCHAR(255) NOT NULL,\n  UNIQUE (table_id)\n)")
    public void createSourceTableTable();

    @SqlUpdate(value="INSERT INTO source_table (table_id, catalog_name, schema_name, table_name)\nVALUES (:tableId, :catalogName, :schemaName, :tableName)")
    @GetGeneratedKeys
    public long insertSourceTable(@Bind(value="tableId") long var1, @BindBean QualifiedTableName var3);

    @SqlUpdate(value="DELETE FROM source_table WHERE table_id = :tableId")
    public int dropSourceTable(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT catalog_name, schema_name, table_name\nFROM source_table\nWHERE table_id = :tableId\n")
    @Mapper(value=QualifiedTableNameMapper.class)
    public QualifiedTableName getSourceTable(@Bind(value="tableId") long var1);

    public static class Utils {
        public static final Logger log = Logger.get(StorageDao.class);

        public static void createStorageTablesWithRetry(StorageDao dao) throws InterruptedException {
            Duration delay = new Duration(10.0, TimeUnit.SECONDS);
            while (true) {
                try {
                    Utils.createStorageTables(dao);
                    return;
                }
                catch (UnableToObtainConnectionException e) {
                    log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                    Thread.sleep(delay.toMillis());
                    continue;
                }
                break;
            }
        }

        public static void createStorageTables(StorageDao dao) {
            dao.createSourceTableTable();
        }
    }
}

