/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.operator.SortOrder;
import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;

public class FieldOrderedTupleComparator
implements Comparator<TupleReadable[]> {
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;

    public FieldOrderedTupleComparator(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        Preconditions.checkArgument((sortChannels.size() == sortOrders.size() ? 1 : 0) != 0, (String)"sortFields size (%s) doesn't match sortOrders size (%s)", (Object[])new Object[]{sortChannels.size(), sortOrders.size()});
        this.sortChannels = ImmutableList.copyOf(sortChannels);
        this.sortOrders = ImmutableList.copyOf(sortOrders);
    }

    @Override
    public int compare(TupleReadable[] leftRow, TupleReadable[] rightRow) {
        for (int index = 0; index < this.sortChannels.size(); ++index) {
            int comparison;
            int channel = this.sortChannels.get(index);
            SortOrder sortOrder = this.sortOrders.get(index);
            TupleReadable left = leftRow[channel];
            TupleReadable right = rightRow[channel];
            boolean leftIsNull = left.isNull();
            boolean rightIsNull = right.isNull();
            if (leftIsNull && rightIsNull) {
                return 0;
            }
            if (leftIsNull) {
                return sortOrder.isNullsFirst() ? -1 : 1;
            }
            if (rightIsNull) {
                return sortOrder.isNullsFirst() ? 1 : -1;
            }
            TupleInfo.Type type = left.getTupleInfo().getType();
            switch (type) {
                case BOOLEAN: {
                    comparison = Boolean.compare(left.getBoolean(), right.getBoolean());
                    break;
                }
                case FIXED_INT_64: {
                    comparison = Long.compare(left.getLong(), right.getLong());
                    break;
                }
                case DOUBLE: {
                    comparison = Double.compare(left.getDouble(), right.getDouble());
                    break;
                }
                case VARIABLE_BINARY: {
                    comparison = left.getSlice().compareTo(right.getSlice());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unimplemented type: " + type));
                }
            }
            if (comparison == 0) continue;
            return sortOrder.isAscending() ? comparison : -comparison;
        }
        return 0;
    }
}

