/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.tuple.TupleInfo;
import com.facebook.presto.tuple.TupleReadable;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;

public class Tuple
implements TupleReadable {
    private final Slice slice;
    private final TupleInfo tupleInfo;

    public Tuple(Slice slice, TupleInfo tupleInfo) {
        this.slice = slice;
        this.tupleInfo = tupleInfo;
    }

    @Override
    public TupleInfo getTupleInfo() {
        return this.tupleInfo;
    }

    @Override
    public Tuple getTuple() {
        return this;
    }

    public Slice getTupleSlice() {
        return this.slice;
    }

    @Override
    public boolean getBoolean() {
        return this.tupleInfo.getBoolean(this.slice);
    }

    @Override
    public long getLong() {
        return this.tupleInfo.getLong(this.slice);
    }

    @Override
    public double getDouble() {
        return this.tupleInfo.getDouble(this.slice);
    }

    @Override
    public Slice getSlice() {
        return this.tupleInfo.getSlice(this.slice);
    }

    @Override
    public boolean isNull() {
        return this.tupleInfo.isNull(this.slice);
    }

    public int size() {
        return this.tupleInfo.size(this.slice);
    }

    public void writeTo(SliceOutput out) {
        out.writeBytes(this.slice);
    }

    public Object getObjectValue() {
        if (this.isNull()) {
            return null;
        }
        TupleInfo.Type type = this.tupleInfo.getType();
        switch (type) {
            case BOOLEAN: {
                return this.getBoolean();
            }
            case FIXED_INT_64: {
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case VARIABLE_BINARY: {
                Slice slice = this.getSlice();
                return slice.toString(Charsets.UTF_8);
            }
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return this.slice.equals((Object)tuple.slice);
    }

    public int hashCode() {
        int result = this.slice.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("tupleInfo", (Object)this.tupleInfo).add("value", this.getObjectValue()).toString();
    }
}

