/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleReadable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;

public class TupleInfo {
    public static final TupleInfo SINGLE_BOOLEAN = new TupleInfo(Type.BOOLEAN);
    public static final TupleInfo SINGLE_LONG = new TupleInfo(Type.FIXED_INT_64);
    public static final TupleInfo SINGLE_VARBINARY = new TupleInfo(Type.VARIABLE_BINARY);
    public static final TupleInfo SINGLE_DOUBLE = new TupleInfo(Type.DOUBLE);
    private final Type type;

    @JsonCreator
    public TupleInfo(Type tupleType) {
        this.type = (Type)Preconditions.checkNotNull((Object)tupleType, (Object)"tupleType is null");
    }

    @JsonValue
    public Type getType() {
        return this.type;
    }

    public int getFixedSize() {
        return this.type.getSize() + 1;
    }

    public int size(Slice slice) {
        return this.size(slice, 0);
    }

    public int size(Slice slice, int offset) {
        if (this.type.isFixedSize()) {
            return this.type.getSize() + 1;
        }
        return slice.getInt(offset + 1);
    }

    public int size(SliceInput sliceInput) {
        if (this.type.isFixedSize()) {
            return this.type.getSize();
        }
        int originalPosition = sliceInput.position();
        sliceInput.skipBytes(1);
        int tupleSize = sliceInput.readInt();
        sliceInput.setPosition(originalPosition);
        return tupleSize;
    }

    public boolean getBoolean(Slice slice) {
        return this.getBoolean(slice, 0);
    }

    public boolean getBoolean(Slice slice, int offset) {
        Preconditions.checkState((this.type == Type.BOOLEAN ? 1 : 0) != 0, (String)"Expected BOOLEAN, but is %s", (Object[])new Object[]{this.type});
        return slice.getByte(offset + 1) != 0;
    }

    public void setBoolean(Slice slice, boolean value) {
        this.setBoolean(slice, 0, value);
    }

    public void setBoolean(Slice slice, int offset, boolean value) {
        Preconditions.checkState((this.type == Type.BOOLEAN ? 1 : 0) != 0, (String)"Expected BOOLEAN, but is %s", (Object[])new Object[]{this.type});
        slice.setByte(offset + 1, value ? 1 : 0);
    }

    public long getLong(Slice slice) {
        return this.getLong(slice, 0);
    }

    public long getLong(Slice slice, int offset) {
        Preconditions.checkState((this.type == Type.FIXED_INT_64 ? 1 : 0) != 0, (String)"Expected FIXED_INT_64, but is %s", (Object[])new Object[]{this.type});
        return slice.getLong(offset + 1);
    }

    public void setLong(Slice slice, long value) {
        this.setLong(slice, 0, value);
    }

    public void setLong(Slice slice, int offset, long value) {
        Preconditions.checkState((this.type == Type.FIXED_INT_64 ? 1 : 0) != 0, (String)"Expected FIXED_INT_64, but is %s", (Object[])new Object[]{this.type});
        slice.setLong(offset + 1, value);
    }

    public double getDouble(Slice slice) {
        return this.getDouble(slice, 0);
    }

    public double getDouble(Slice slice, int offset) {
        Preconditions.checkState((this.type == Type.DOUBLE ? 1 : 0) != 0, (String)"Expected DOUBLE, but is %s", (Object[])new Object[]{this.type});
        return slice.getDouble(offset + 1);
    }

    public void setDouble(Slice slice, double value) {
        this.setDouble(slice, 0, value);
    }

    public void setDouble(Slice slice, int offset, double value) {
        Preconditions.checkState((this.type == Type.DOUBLE ? 1 : 0) != 0, (String)"Expected DOUBLE, but is %s", (Object[])new Object[]{this.type});
        slice.setDouble(offset + 1, value);
    }

    public Slice getSlice(Slice slice) {
        return this.getSlice(slice, 0);
    }

    public Slice getSlice(Slice slice, int offset) {
        Preconditions.checkState((this.type == Type.VARIABLE_BINARY ? 1 : 0) != 0, (String)"Expected VARIABLE_BINARY, but is %s", (Object[])new Object[]{this.type});
        int size = slice.getInt(offset + 1);
        return slice.slice(offset + 4 + 1, size - 4 - 1);
    }

    public boolean isNull(Slice slice) {
        return this.isNull(slice, 0);
    }

    public boolean isNull(Slice slice, int offset) {
        return slice.getByte(offset) != 0;
    }

    public void setNull(Slice slice, int offset) {
        slice.setByte(offset, 1);
    }

    public void setNotNull(Slice slice) {
        this.setNotNull(slice, 0);
    }

    public void setNotNull(Slice slice, int offset) {
        slice.setByte(offset, 0);
    }

    public Slice extractTupleSlice(SliceInput sliceInput) {
        int tupleSliceSize = this.size(sliceInput);
        return sliceInput.readSlice(tupleSliceSize);
    }

    public Builder builder(SliceOutput sliceOutput) {
        return new Builder(sliceOutput);
    }

    public Builder builder() {
        return new Builder((SliceOutput)new DynamicSliceOutput(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleInfo tupleInfo = (TupleInfo)o;
        return this.type.equals(tupleInfo.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "TupleInfo{" + this.type + "}";
    }

    public class Builder {
        private final SliceOutput sliceOutput;

        public Builder(SliceOutput sliceOutput) {
            this.sliceOutput = sliceOutput;
        }

        public Builder append(boolean value) {
            Preconditions.checkState((TupleInfo.this.type == Type.BOOLEAN ? 1 : 0) != 0, (String)"Cannot append boolean to type %s", (Object[])new Object[]{TupleInfo.this.type});
            this.sliceOutput.writeByte(0);
            this.sliceOutput.writeByte(value ? 1 : 0);
            return this;
        }

        public Builder append(long value) {
            Preconditions.checkState((TupleInfo.this.type == Type.FIXED_INT_64 ? 1 : 0) != 0, (String)"Cannot append long to type %s", (Object[])new Object[]{TupleInfo.this.type});
            this.sliceOutput.writeByte(0);
            this.sliceOutput.writeLong(value);
            return this;
        }

        public Builder append(double value) {
            Preconditions.checkState((TupleInfo.this.type == Type.DOUBLE ? 1 : 0) != 0, (String)"Cannot append double to type %s", (Object[])new Object[]{TupleInfo.this.type});
            this.sliceOutput.writeByte(0);
            this.sliceOutput.writeDouble(value);
            return this;
        }

        public Builder append(String value) {
            return this.append(Slices.copiedBuffer((String)value, (Charset)Charsets.UTF_8));
        }

        public Builder append(Slice value) {
            Preconditions.checkState((TupleInfo.this.type == Type.VARIABLE_BINARY ? 1 : 0) != 0, (String)"Cannot append binary to type %s", (Object[])new Object[]{TupleInfo.this.type});
            this.sliceOutput.writeByte(0);
            this.sliceOutput.writeInt(value.length() + 1 + 4);
            this.sliceOutput.writeBytes(value);
            return this;
        }

        public Builder appendNull() {
            this.sliceOutput.writeByte(1);
            switch (TupleInfo.this.type) {
                case FIXED_INT_64: {
                    this.sliceOutput.writeLong(0L);
                    break;
                }
                case VARIABLE_BINARY: {
                    this.sliceOutput.writeInt(5);
                    break;
                }
                case DOUBLE: {
                    this.sliceOutput.writeDouble(0.0);
                    break;
                }
                case BOOLEAN: {
                    this.sliceOutput.writeByte(0);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported type: " + TupleInfo.this.type);
                }
            }
            return this;
        }

        public Builder append(TupleReadable tuple) {
            Preconditions.checkArgument((TupleInfo.this.type == tuple.getTupleInfo().getType() ? 1 : 0) != 0, (String)"Type (%s) does not match tuple type (%s)", (Object[])new Object[]{TupleInfo.this.type, tuple.getTupleInfo().getType()});
            if (tuple.isNull()) {
                this.appendNull();
            } else {
                switch (TupleInfo.this.type) {
                    case BOOLEAN: {
                        this.append(tuple.getBoolean());
                        break;
                    }
                    case FIXED_INT_64: {
                        this.append(tuple.getLong());
                        break;
                    }
                    case DOUBLE: {
                        this.append(tuple.getDouble());
                        break;
                    }
                    case VARIABLE_BINARY: {
                        this.append(tuple.getSlice());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Type not yet supported: " + TupleInfo.this.type);
                    }
                }
            }
            return this;
        }

        public Tuple build() {
            return new Tuple(this.sliceOutput.slice(), TupleInfo.this);
        }
    }

    public static enum Type implements Comparable<Type>
    {
        FIXED_INT_64(8, "bigint"),
        VARIABLE_BINARY(-1, "varchar"),
        DOUBLE(8, "double"),
        BOOLEAN(1, "boolean");

        private static final Map<String, Type> NAMES;
        private final int size;
        private final String name;

        private Type(int size, String name) {
            this.size = size;
            this.name = name;
        }

        int getSize() {
            Preconditions.checkState((boolean)this.isFixedSize(), (Object)"Can't get size of variable length value");
            return this.size;
        }

        boolean isFixedSize() {
            return this.size != -1;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        public ColumnType toColumnType() {
            switch (this) {
                case BOOLEAN: {
                    return ColumnType.BOOLEAN;
                }
                case FIXED_INT_64: {
                    return ColumnType.LONG;
                }
                case DOUBLE: {
                    return ColumnType.DOUBLE;
                }
                case VARIABLE_BINARY: {
                    return ColumnType.STRING;
                }
            }
            throw new IllegalStateException("Unknown type " + this);
        }

        public static Type fromColumnType(ColumnType type) {
            switch (type) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case LONG: {
                    return FIXED_INT_64;
                }
                case STRING: {
                    return VARIABLE_BINARY;
                }
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        @JsonCreator
        public static Type fromName(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            Type encoding = NAMES.get(name);
            Preconditions.checkArgument((encoding != null ? 1 : 0) != 0, (String)"Invalid type name: %s", (Object[])new Object[]{name});
            return encoding;
        }

        public static Function<Type, String> nameGetter() {
            return new Function<Type, String>(){

                public String apply(Type type) {
                    return type.getName();
                }
            };
        }

        static {
            NAMES = Maps.uniqueIndex(Arrays.asList(Type.values()), Type.nameGetter());
        }
    }
}

