/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tuple;

import com.facebook.presto.tuple.Tuple;
import com.facebook.presto.tuple.TupleInfo;
import com.google.common.base.Charsets;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class Tuples {
    public static final Tuple NULL_BOOLEAN_TUPLE = Tuples.nullTuple(TupleInfo.SINGLE_BOOLEAN);
    public static final Tuple NULL_STRING_TUPLE = Tuples.nullTuple(TupleInfo.SINGLE_VARBINARY);
    public static final Tuple NULL_LONG_TUPLE = Tuples.nullTuple(TupleInfo.SINGLE_LONG);
    public static final Tuple NULL_DOUBLE_TUPLE = Tuples.nullTuple(TupleInfo.SINGLE_DOUBLE);

    private Tuples() {
    }

    public static Tuple nullTuple(TupleInfo tupleInfo) {
        return tupleInfo.builder().appendNull().build();
    }

    public static Tuple createTuple(boolean value) {
        return TupleInfo.SINGLE_BOOLEAN.builder().append(value).build();
    }

    public static Tuple createTuple(long value) {
        return TupleInfo.SINGLE_LONG.builder().append(value).build();
    }

    public static Tuple createTuple(double value) {
        return TupleInfo.SINGLE_DOUBLE.builder().append(value).build();
    }

    public static Tuple createTuple(String value) {
        return Tuples.createTuple(Slices.wrappedBuffer((byte[])value.getBytes(Charsets.UTF_8)));
    }

    public static Tuple createTuple(Slice value) {
        return TupleInfo.SINGLE_VARBINARY.builder().append(value).build();
    }
}

