/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.SimpleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.util.QueryExplanation;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import java.util.List;
import java.util.Map;

public final class JsonPlanPrinter {
    private static final JsonCodec<QueryExplanation> CODEC = JsonCodec.jsonCodec(QueryExplanation.class);
    private final ImmutableList.Builder<Input> inputBuilder = ImmutableList.builder();

    private JsonPlanPrinter(PlanNode plan, Metadata metadata) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        SourceVisitor visitor = new SourceVisitor(metadata);
        plan.accept(visitor, null);
    }

    public static String getPlan(PlanNode plan, Metadata metadata) {
        return new JsonPlanPrinter(plan, metadata).toString();
    }

    public String toString() {
        return CODEC.toJson((Object)new QueryExplanation((List<Input>)this.inputBuilder.build()));
    }

    private class SourceVisitor
    extends PlanVisitor<Void, Void> {
        private final Metadata metadata;

        public SourceVisitor(Metadata metadata) {
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getLeft().accept(this, null);
            node.getRight().accept(this, null);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            node.getSource().accept(this, null);
            node.getFilteringSource().accept(this, null);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TupleDomain partitionsDomainSummary = node.getPartitionsDomainSummary();
            TableMetadata tableMetadata = this.metadata.getTableMetadata(node.getTable());
            ImmutableList.Builder columnBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(node.getTable(), entry.getValue());
                Domain domain = null;
                if (!partitionsDomainSummary.isNone() && partitionsDomainSummary.getDomains().keySet().contains(entry.getValue())) {
                    domain = (Domain)partitionsDomainSummary.getDomains().get(entry.getValue());
                } else if (partitionsDomainSummary.isNone()) {
                    domain = Domain.none((Class)columnMetadata.getType().getNativeType());
                }
                Column column = new Column(columnMetadata.getName(), columnMetadata.getType().toString(), (Optional<SimpleDomain>)Optional.fromNullable((Object)SimpleDomain.fromDomain(domain)));
                columnBuilder.add((Object)column);
            }
            Input input = new Input(tableMetadata.getConnectorId(), tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<Column>)columnBuilder.build());
            JsonPlanPrinter.this.inputBuilder.add((Object)input);
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTopN(TopNNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            return null;
        }

        @Override
        public Void visitSink(SinkNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTableCommit(TableCommitNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, null);
            }
            return null;
        }
    }
}

