/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class MoreFutures {
    private MoreFutures() {
    }

    public static <T> T tryGetUnchecked(Future<T> future) {
        Preconditions.checkNotNull(future, (Object)"future is null");
        if (!future.isDone()) {
            return null;
        }
        try {
            return future.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw Throwables.propagate((Throwable)cause);
        }
        catch (TimeoutException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

