/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.array;

import com.facebook.presto.util.array.BigArrays;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class ByteBigArray {
    private static final long SIZE_OF_SEGMENT = (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)Unsafe.ARRAY_BYTE_INDEX_SCALE * 1024L;
    private byte[][] array = new byte[1024][];
    private int capacity;
    private int segments;

    public ByteBigArray() {
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public byte get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, byte value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (byte[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        this.array[this.segments] = new byte[1024];
        this.capacity += 1024;
        ++this.segments;
    }
}

