/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.array;

import com.facebook.presto.util.array.BigArrays;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class DoubleBigArray {
    private static final long SIZE_OF_SEGMENT = (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE * 1024L;
    private double[][] array = new double[1024][];
    private int capacity;
    private int segments;

    public DoubleBigArray() {
        this.allocateNewSegment();
    }

    public DoubleBigArray(double defaultValue) {
        this.allocateNewSegment(defaultValue);
    }

    public long sizeOf() {
        return SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public double get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, double value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void add(long index, double value) {
        double[] dArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        dArray[n] = dArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (double[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        this.array[this.segments] = new double[1024];
        this.capacity += 1024;
        ++this.segments;
    }

    public void ensureCapacity(long length, double defaultValue) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length, defaultValue);
    }

    private void grow(long length, double defaultValue) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (double[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment(defaultValue);
        }
    }

    private void allocateNewSegment(double defaultValue) {
        double[] newSegment = new double[1024];
        Arrays.fill(newSegment, defaultValue);
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }
}

