/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.array;

import com.facebook.presto.util.array.BigArrays;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class LongBigArray {
    private static final long SIZE_OF_SEGMENT = (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)Unsafe.ARRAY_LONG_INDEX_SCALE * 1024L;
    private long[][] array = new long[1024][];
    private int capacity;
    private int segments;

    public LongBigArray() {
        this.allocateNewSegment();
    }

    public LongBigArray(long defaultValue) {
        this.allocateNewSegment(defaultValue);
    }

    public long sizeOf() {
        return SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public long get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, long value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        long[] lArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        lArray[n] = lArray[n] + 1L;
    }

    public void add(long index, long value) {
        long[] lArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        lArray[n] = lArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (long[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        this.array[this.segments] = new long[1024];
        this.capacity += 1024;
        ++this.segments;
    }

    public void ensureCapacity(long length, long defaultValue) {
        if ((long)this.capacity > length) {
            return;
        }
        this.grow(length, defaultValue);
    }

    private void grow(long length, long defaultValue) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (long[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment(defaultValue);
        }
    }

    private void allocateNewSegment(long defaultValue) {
        long[] newSegment = new long[1024];
        Arrays.fill(newSegment, defaultValue);
        this.array[this.segments] = newSegment;
        this.capacity += 1024;
        ++this.segments;
    }
}

