/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import javax.jdo.JDOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RetryingRawStore
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(RetryingRawStore.class);
    private final RawStore base;
    private int retryInterval = 0;
    private int retryLimit = 0;
    private MetaStoreInit.MetaStoreInitData metaStoreInitData = new MetaStoreInit.MetaStoreInitData();
    private final int id;
    private final HiveConf hiveConf;
    private final Configuration conf;

    protected RetryingRawStore(HiveConf hiveConf, Configuration conf, Class<? extends RawStore> rawStoreClass, int id) throws MetaException {
        this.conf = conf;
        this.hiveConf = hiveConf;
        this.id = id;
        this.init();
        this.base = (RawStore)ReflectionUtils.newInstance(rawStoreClass, (Configuration)conf);
    }

    public static RawStore getProxy(HiveConf hiveConf, Configuration conf, String rawStoreClassName, int id) throws MetaException {
        Class<?> baseClass = MetaStoreUtils.getClass(rawStoreClassName);
        RetryingRawStore handler = new RetryingRawStore(hiveConf, conf, baseClass, id);
        return (RawStore)Proxy.newProxyInstance(RetryingRawStore.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    private void init() throws MetaException {
        this.retryInterval = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTOREINTERVAL);
        this.retryLimit = HiveConf.getIntVar(this.hiveConf, HiveConf.ConfVars.METASTOREATTEMPTS);
        MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), null, this.metaStoreInitData);
    }

    private void initMS() {
        this.base.setConf(this.getConf());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        boolean gotNewConnectUrl = false;
        boolean reloadConf = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.METASTOREFORCERELOADCONF);
        if (reloadConf) {
            MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), null, this.metaStoreInitData);
        }
        int retryCount = 0;
        JDOException caughtException = null;
        while (true) {
            try {
                if (reloadConf || gotNewConnectUrl) {
                    this.initMS();
                }
                ret = method.invoke((Object)this.base, args);
                break;
            }
            catch (JDOException e) {
                caughtException = e;
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JDOException) {
                    caughtException = (JDOException)e.getCause();
                }
                throw e.getCause();
            }
            if (retryCount >= this.retryLimit) {
                throw caughtException;
            }
            assert (this.retryInterval >= 0);
            LOG.error(String.format("JDO datastore error. Retrying metastore command after %d ms (attempt %d of %d)", this.retryInterval, ++retryCount, this.retryLimit));
            Thread.sleep(this.retryInterval);
            String lastUrl = MetaStoreInit.getConnectionURL(this.getConf());
            gotNewConnectUrl = MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), lastUrl, this.metaStoreInitData);
        }
        return ret;
    }

    private String addPrefix(String s) {
        return this.id + ": " + s;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

