/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.DelimitedJSONSerDe;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.util.ReflectionUtils;

public class ListSinkOperator
extends Operator<ListSinkDesc> {
    private transient SerDe mSerde;
    private transient ArrayList<String> res;
    private transient int numRows;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.mSerde = this.initializeSerde(hconf);
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private SerDe initializeSerde(Configuration conf) throws Exception {
        String serdeName = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE);
        Class<SerDe> serdeClass = Class.forName(serdeName, true, JavaUtils.getClassLoader()).asSubclass(SerDe.class);
        SerDe serde = (SerDe)ReflectionUtils.newInstance(serdeClass, null);
        Properties serdeProp = new Properties();
        if (serde instanceof DelimitedJSONSerDe) {
            serdeProp.put("serialization.format", "9");
            serdeProp.put("serialization.null.format", ((ListSinkDesc)this.getConf()).getSerializationNullFormat());
        }
        serde.initialize(conf, serdeProp);
        return serde;
    }

    public ListSinkOperator initialize(SerDe mSerde) {
        this.mSerde = mSerde;
        return this;
    }

    public void reset(ArrayList<String> res) {
        this.res = res;
        this.numRows = 0;
    }

    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            this.res.add(this.mSerde.serialize(row, this.outputObjInspector).toString());
            ++this.numRows;
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FORWARD;
    }
}

