/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.PTFPersistence;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;

public class PTFPartition {
    SerDe serDe;
    StructObjectInspector OI;
    private PTFPersistence.ByteBasedList elems;
    private Writable wRow;
    private int sz;

    public PTFPartition(HiveConf cfg, SerDe serDe, StructObjectInspector oI) throws HiveException {
        String partitionClass = HiveConf.getVar(cfg, HiveConf.ConfVars.HIVE_PTF_PARTITION_PERSISTENCE_CLASS);
        int partitionMemSize = HiveConf.getIntVar(cfg, HiveConf.ConfVars.HIVE_PTF_PARTITION_PERSISTENT_SIZE);
        this.init(partitionClass, partitionMemSize, serDe, oI);
    }

    public PTFPartition(String partitionClass, int partitionMemSize, SerDe serDe, StructObjectInspector oI) throws HiveException {
        this.init(partitionClass, partitionMemSize, serDe, oI);
    }

    private void init(String partitionClass, int partitionMemSize, SerDe serDe, StructObjectInspector oI) throws HiveException {
        this.serDe = serDe;
        this.OI = oI;
        this.elems = PTFPersistence.createList(partitionClass, partitionMemSize);
        this.sz = 0;
        this.wRow = this.createWritable();
    }

    public void reset() throws HiveException {
        this.sz = 0;
        this.elems.reset(0);
    }

    public SerDe getSerDe() {
        return this.serDe;
    }

    public void setSerDe(SerDe serDe) {
        this.serDe = serDe;
    }

    public StructObjectInspector getOI() {
        return this.OI;
    }

    public void setOI(StructObjectInspector oI) {
        this.OI = oI;
    }

    private Writable createWritable() throws HiveException {
        try {
            return this.serDe.getSerializedClass().newInstance();
        }
        catch (Throwable t) {
            throw new HiveException(t);
        }
    }

    public Object getAt(int i) throws HiveException {
        try {
            this.elems.get(i, this.wRow);
            Object o = this.serDe.deserialize(this.wRow);
            return o;
        }
        catch (SerDeException se) {
            throw new HiveException(se);
        }
    }

    public Object getWritableAt(int i) throws HiveException {
        this.elems.get(i, this.wRow);
        return this.wRow;
    }

    public void append(Writable o) throws HiveException {
        this.elems.append(o);
        ++this.sz;
    }

    public void append(Object o) throws HiveException {
        try {
            this.append(this.serDe.serialize(o, this.OI));
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    public int size() {
        return this.sz;
    }

    public PTFPartitionIterator<Object> iterator() {
        return new PItr(0, this.size());
    }

    public PTFPartitionIterator<Object> range(int start, int end) {
        assert (start >= 0);
        assert (end <= this.size());
        assert (start <= end);
        return new PItr(start, end);
    }

    public static interface PTFPartitionIterator<T>
    extends Iterator<T> {
        public int getIndex();

        public T lead(int var1);

        public T lag(int var1);

        public Object resetToIndex(int var1);

        public PTFPartition getPartition();

        public void reset();
    }

    class PItr
    implements PTFPartitionIterator<Object> {
        int idx;
        final int start;
        final int end;
        final int createTimeSz;

        PItr(int start, int end) {
            this.idx = start;
            this.start = start;
            this.end = end;
            this.createTimeSz = PTFPartition.this.size();
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            return this.idx < this.end;
        }

        @Override
        public Object next() {
            this.checkForComodification();
            try {
                return PTFPartition.this.getAt(this.idx++);
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        final void checkForComodification() {
            if (this.createTimeSz != PTFPartition.this.size()) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int getIndex() {
            return this.idx;
        }

        private Object getAt(int i) {
            try {
                return PTFPartition.this.getAt(i);
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object lead(int amt) {
            int i = this.idx + amt;
            i = i >= this.end ? this.end - 1 : i;
            return this.getAt(i);
        }

        @Override
        public Object lag(int amt) {
            int i = this.idx - amt;
            i = i < this.start ? this.start : i;
            return this.getAt(i);
        }

        @Override
        public Object resetToIndex(int idx) {
            if (idx < this.start || idx >= this.end) {
                return null;
            }
            Object o = this.getAt(idx);
            this.idx = idx + 1;
            return o;
        }

        @Override
        public PTFPartition getPartition() {
            return PTFPartition.this;
        }

        @Override
        public void reset() {
            this.idx = this.start;
        }
    }
}

