/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;

class ZlibCodec
implements CompressionCodec {
    ZlibCodec() {
    }

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow) throws IOException {
        Deflater deflater = new Deflater(-1, true);
        int length = in.remaining();
        deflater.setInput(in.array(), in.arrayOffset() + in.position(), length);
        deflater.finish();
        int outSize = 0;
        int offset = out.arrayOffset() + out.position();
        while (!deflater.finished() && length > outSize) {
            int size = deflater.deflate(out.array(), offset, out.remaining());
            out.position(size + out.position());
            outSize += size;
            offset += size;
            if (out.remaining() != 0) continue;
            if (overflow == null) {
                deflater.end();
                return false;
            }
            out = overflow;
            offset = out.arrayOffset() + out.position();
        }
        deflater.end();
        return length > outSize;
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(in.array(), in.arrayOffset() + in.position(), in.remaining());
        while (!(inflater.finished() || inflater.needsDictionary() || inflater.needsInput())) {
            try {
                int count = inflater.inflate(out.array(), out.arrayOffset() + out.position(), out.remaining());
                out.position(count + out.position());
            }
            catch (DataFormatException dfe) {
                throw new IOException("Bad compression data", dfe);
            }
        }
        out.flip();
        inflater.end();
        in.position(in.limit());
    }
}

