/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.stats;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Throttle;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;

public class PartialScanTask
extends Task<PartialScanWork>
implements Serializable,
HadoopJobExecHook {
    private static final long serialVersionUID = 1L;
    protected transient JobConf job;
    protected HadoopJobExecHelper jobExecHelper;
    boolean success = true;
    public static String INPUT_SEPERATOR = ":";

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        super.initialize(conf, queryPlan, driverContext);
        this.job = new JobConf((Configuration)conf, PartialScanTask.class);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        String inpFormat;
        HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, CombineHiveInputFormat.class.getName());
        this.success = true;
        ShimLoader.getHadoopShims().prepareJobOutput(this.job);
        this.job.setOutputFormat(HiveOutputFormatImpl.class);
        this.job.setMapperClass(((PartialScanWork)this.work).getMapperClass());
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        try {
            if (ctx == null) {
                ctx = new Context((Configuration)this.job);
                ctxCreated = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.console.printError("Error launching map-reduce job", "\n" + StringUtils.stringifyException((Throwable)e));
            return 5;
        }
        this.job.setMapOutputKeyClass(NullWritable.class);
        this.job.setMapOutputValueClass(NullWritable.class);
        if (((PartialScanWork)this.work).getNumMapTasks() != null) {
            this.job.setNumMapTasks(((PartialScanWork)this.work).getNumMapTasks().intValue());
        }
        this.job.setNumReduceTasks(0);
        if (((PartialScanWork)this.work).getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZE, ((PartialScanWork)this.work).getMinSplitSize());
        }
        if (((PartialScanWork)this.work).getInputformat() != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, ((PartialScanWork)this.work).getInputformat());
        }
        if ((inpFormat = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT)) == null || !com.facebook.presto.hive.shaded.org.apache.commons.lang.StringUtils.isNotBlank(inpFormat)) {
            inpFormat = ShimLoader.getHadoopShims().getInputFormatClassName();
        }
        LOG.info("Using " + inpFormat);
        try {
            this.job.setInputFormat(Class.forName(inpFormat));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(NullWritable.class);
        int returnVal = 0;
        RunningJob rj = null;
        boolean noName = com.facebook.presto.hive.shaded.org.apache.commons.lang.StringUtils.isEmpty(HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJOBNAME));
        String jobName = null;
        if (noName && this.getQueryPlan() != null) {
            int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
            jobName = Utilities.abbreviate(this.getQueryPlan().getQueryStr(), maxlen - 6);
        }
        if (noName) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HADOOPJOBNAME, jobName != null ? jobName : "JOB" + Utilities.randGen.nextInt());
        }
        HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX, ((PartialScanWork)this.work).getAggKey());
        try {
            StatsPublisher statsPublisher;
            String statsImplementationClass;
            this.addInputPaths(this.job, (PartialScanWork)this.work);
            Utilities.setMapRedWork((Configuration)this.job, (MapredWork)this.work, ctx.getMRTmpFileURI());
            String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
            if (pwd != null) {
                HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
            }
            JobClient jc = new JobClient(this.job);
            String addedJars = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR);
            if (!addedJars.isEmpty()) {
                this.job.set("tmpjars", addedJars);
            }
            Throttle.checkJobTracker(this.job, LOG);
            if (((PartialScanWork)this.work).isGatheringStats() && StatsFactory.setImplementation(statsImplementationClass = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVESTATSDBCLASS), (Configuration)this.job) && !(statsPublisher = StatsFactory.getStatsPublisher()).init((Configuration)this.job) && HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
            }
            rj = jc.submitJob(this.job);
            returnVal = this.jobExecHelper.progress(rj, jc);
            this.success = returnVal == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            String mesg = " with exception '" + Utilities.getNameMessage(e) + "'";
            mesg = rj != null ? "Ended Job = " + rj.getJobID() + mesg : "Job Submission failed" + mesg;
            this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
            this.success = false;
            returnVal = 1;
        }
        finally {
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null) {
                    if (returnVal != 0) {
                        rj.killJob();
                    }
                    HadoopJobExecHelper.runningJobKillURIs.remove(rj.getJobID());
                    this.jobID = rj.getID().toString();
                }
            }
            catch (Exception e) {}
        }
        return returnVal;
    }

    private void addInputPaths(JobConf job, PartialScanWork work) {
        for (String path : work.getInputPaths()) {
            FileInputFormat.addInputPath((JobConf)job, (Path)new Path(path));
        }
    }

    @Override
    public String getName() {
        return "RCFile Statistics Partial Scan";
    }

    public static void main(String[] args) {
        String inputPathStr = null;
        String outputDir = null;
        String jobConfFileName = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-input")) {
                    inputPathStr = args[++i];
                    continue;
                }
                if (args[i].equals("-jobconffile")) {
                    jobConfFileName = args[++i];
                    continue;
                }
                if (!args[i].equals("-outputDir")) continue;
                outputDir = args[++i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Missing argument to option");
            PartialScanTask.printUsage();
        }
        if (inputPathStr == null || outputDir == null || outputDir.trim().equals("")) {
            PartialScanTask.printUsage();
        }
        ArrayList<String> inputPaths = new ArrayList<String>();
        String[] paths = inputPathStr.split(INPUT_SEPERATOR);
        if (paths == null || paths.length == 0) {
            PartialScanTask.printUsage();
        }
        FileSystem fs = null;
        JobConf conf = new JobConf(PartialScanTask.class);
        for (String path : paths) {
            try {
                FileStatus fstatus;
                Path pathObj = new Path(path);
                if (fs == null) {
                    fs = FileSystem.get((URI)pathObj.toUri(), (Configuration)conf);
                }
                if ((fstatus = fs.getFileStatus(pathObj)).isDir()) {
                    FileStatus[] fileStatus;
                    for (FileStatus st : fileStatus = fs.listStatus(pathObj)) {
                        inputPaths.add(st.getPath().toString());
                    }
                    continue;
                }
                inputPaths.add(fstatus.getPath().toString());
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        if (jobConfFileName != null) {
            conf.addResource(new Path(jobConfFileName));
        }
        HiveConf hiveConf = new HiveConf((Configuration)conf, PartialScanTask.class);
        Log LOG = LogFactory.getLog(PartialScanTask.class.getName());
        boolean isSilent = HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVESESSIONSILENT);
        SessionState.LogHelper console = new SessionState.LogHelper(LOG, isSilent);
        for (Appender appender : Collections.list(LogManager.getRootLogger().getAllAppenders())) {
            if (!(appender instanceof FileAppender)) continue;
            console.printInfo("Execution log at: " + ((FileAppender)appender).getFile());
        }
        PartialScanWork mergeWork = new PartialScanWork(inputPaths);
        DriverContext driverCxt = new DriverContext();
        PartialScanTask taskExec = new PartialScanTask();
        taskExec.initialize(hiveConf, null, driverCxt);
        taskExec.setWork(mergeWork);
        int ret = taskExec.execute(driverCxt);
        if (ret != 0) {
            System.exit(2);
        }
    }

    private static void printUsage() {
        System.exit(1);
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        return false;
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
    }

    @Override
    public void updateCounters(Counters ctrs, RunningJob rj) throws IOException {
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
    }
}

