/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class BucketingSortingReduceSinkOptimizer
implements Transform {
    private static final Log LOG = LogFactory.getLog(BucketingSortingReduceSinkOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        HiveConf conf = pctx.getConf();
        opRules.put(new RuleRegExp("R1", ReduceSinkOperator.getOperatorName() + "%" + ExtractOperator.getOperatorName() + "%" + FileSinkOperator.getOperatorName() + "%"), this.getBucketSortReduceSinkProc(pctx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    private NodeProcessor getBucketSortReduceSinkProc(ParseContext pctx) {
        return new BucketSortReduceSinkProcessor(pctx);
    }

    public class BucketSortReduceSinkProcessor
    implements NodeProcessor {
        protected ParseContext pGraphContext;

        public BucketSortReduceSinkProcessor(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }

        private List<Integer> getBucketPositions(List<String> tabBucketCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> posns = new ArrayList<Integer>();
            block0: for (String bucketCol : tabBucketCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (bucketCol.equals(tabCol.getName())) {
                        posns.add(pos);
                        continue block0;
                    }
                    ++pos;
                }
            }
            return posns;
        }

        private List<ObjectPair<Integer, Integer>> getSortPositions(List<Order> tabSortCols, List<FieldSchema> tabCols) {
            ArrayList<ObjectPair<Integer, Integer>> posns = new ArrayList<ObjectPair<Integer, Integer>>();
            block0: for (Order sortCol : tabSortCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (sortCol.getCol().equals(tabCol.getName())) {
                        posns.add(new ObjectPair<Integer, Integer>(pos, sortCol.getOrder()));
                        continue block0;
                    }
                    ++pos;
                }
            }
            return posns;
        }

        private boolean checkPartition(Partition partition, List<Integer> bucketPositionsDest, List<ObjectPair<Integer, Integer>> sortPositionsDest, int numBucketsDest) {
            int numBuckets = partition.getBucketCount();
            if (numBucketsDest != numBuckets) {
                return false;
            }
            List<Integer> partnBucketPositions = this.getBucketPositions(partition.getBucketCols(), partition.getTable().getCols());
            List<ObjectPair<Integer, Integer>> partnSortPositions = this.getSortPositions(partition.getSortCols(), partition.getTable().getCols());
            return ((Object)bucketPositionsDest).equals(partnBucketPositions) && ((Object)sortPositionsDest).equals(partnSortPositions);
        }

        private boolean checkTable(Table table, List<Integer> bucketPositionsDest, List<ObjectPair<Integer, Integer>> sortPositionsDest, int numBucketsDest) {
            int numBuckets = table.getNumBuckets();
            if (numBucketsDest != numBuckets) {
                return false;
            }
            List<Integer> tableBucketPositions = this.getBucketPositions(table.getBucketCols(), table.getCols());
            List<ObjectPair<Integer, Integer>> tableSortPositions = this.getSortPositions(table.getSortCols(), table.getCols());
            return ((Object)bucketPositionsDest).equals(tableBucketPositions) && ((Object)sortPositionsDest).equals(tableSortPositions);
        }

        private void storeBucketPathMapping(TableScanOperator tsOp, FileStatus[] srcs) {
            HashMap<String, Integer> bucketFileNameMapping = new HashMap<String, Integer>();
            for (int pos = 0; pos < srcs.length; ++pos) {
                bucketFileNameMapping.put(srcs[pos].getPath().getName(), pos);
            }
            ((TableScanDesc)tsOp.getConf()).setBucketFileNameMapping(bucketFileNameMapping);
        }

        private void removeReduceSink(ReduceSinkOperator rsOp, TableScanOperator tsOp, FileSinkOperator fsOp, FileStatus[] srcs) {
            if (srcs == null) {
                return;
            }
            this.removeReduceSink(rsOp, tsOp, fsOp);
            this.storeBucketPathMapping(tsOp, srcs);
        }

        private void removeReduceSink(ReduceSinkOperator rsOp, TableScanOperator tsOp, FileSinkOperator fsOp) {
            Operator<OperatorDesc> parRSOp = rsOp.getParentOperators().get(0);
            parRSOp.getChildOperators().set(0, fsOp);
            fsOp.getParentOperators().set(0, parRSOp);
            ((FileSinkDesc)fsOp.getConf()).setMultiFileSpray(false);
            ((FileSinkDesc)fsOp.getConf()).setTotalFiles(1);
            ((FileSinkDesc)fsOp.getConf()).setNumFiles(1);
            tsOp.setUseBucketizedHiveInputFormat(true);
        }

        private int findColumnPosition(List<FieldSchema> cols, String colName) {
            int pos = 0;
            for (FieldSchema col : cols) {
                if (colName.equals(col.getName())) {
                    return pos;
                }
                ++pos;
            }
            return -1;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            fsOp = (FileSinkOperator)nd;
            exOp = (ExtractOperator)fsOp.getParentOperators().get(0);
            rsOp = (ReduceSinkOperator)exOp.getParentOperators().get(0);
            rsOps = this.pGraphContext.getReduceSinkOperatorsAddedByEnforceBucketingSorting();
            if (rsOps != null && !rsOps.contains(rsOp)) {
                return null;
            }
            if (((FileSinkDesc)fsOp.getConf()).getDynPartCtx() != null) {
                return null;
            }
            for (ExprNodeDesc keyCol : ((ReduceSinkDesc)rsOp.getConf()).getKeyCols()) {
                if (keyCol instanceof ExprNodeColumnDesc) continue;
                return null;
            }
            destTable = this.pGraphContext.getFsopToTable().get(fsOp);
            if (destTable == null) {
                return null;
            }
            bucketPositions = this.getBucketPositions(destTable.getBucketCols(), destTable.getCols());
            sortPositions = this.getSortPositions(destTable.getSortCols(), destTable.getCols());
            op /* !! */  = rsOp;
            sourceTableBucketCols = new ArrayList<ExprNodeColumnDesc>();
            sourceTableSortCols = new ArrayList<ExprNodeColumnDesc>();
            block1: while (true) {
                if (op /* !! */ .getParentOperators().size() > 1) {
                    return null;
                }
                if (!((op /* !! */  = op /* !! */ .getParentOperators().get(0)) instanceof TableScanOperator || op /* !! */  instanceof FilterOperator || op /* !! */  instanceof SelectOperator)) {
                    return null;
                }
                if (op /* !! */  instanceof TableScanOperator) {
                    srcTable = this.pGraphContext.getTopToTable().get(op /* !! */ );
                    newBucketPositions = new ArrayList<Integer>();
                    for (pos = 0; pos < bucketPositions.size(); ++pos) {
                        col = (ExprNodeColumnDesc)sourceTableBucketCols.get(pos);
                        colName = col.getColumn();
                        bucketPos = this.findColumnPosition(srcTable.getCols(), colName);
                        if (bucketPos < 0) {
                            return null;
                        }
                        newBucketPositions.add(bucketPos);
                    }
                    newSortPositions = new ArrayList<ObjectPair<Integer, Integer>>();
                    for (pos = 0; pos < sortPositions.size(); ++pos) {
                        col = (ExprNodeColumnDesc)sourceTableSortCols.get(pos);
                        colName = col.getColumn();
                        sortPos = this.findColumnPosition(srcTable.getCols(), colName);
                        if (sortPos < 0) {
                            return null;
                        }
                        newSortPositions.add(new ObjectPair<Integer, Integer>(sortPos, sortPositions.get(pos).getSecond()));
                    }
                    if (srcTable.isPartitioned()) {
                        prunedParts = this.pGraphContext.getOpToPartList().get(op /* !! */ );
                        partitions = prunedParts.getNotDeniedPartns();
                        if (partitions == null || partitions.isEmpty() || partitions.size() > 1) {
                            return null;
                        }
                        for (Partition partition : partitions) {
                            if (this.checkPartition(partition, newBucketPositions, newSortPositions, this.pGraphContext.getFsopToTable().get(fsOp).getNumBuckets())) continue;
                            return null;
                        }
                        this.removeReduceSink(rsOp, (TableScanOperator)op /* !! */ , fsOp, partitions.get(0).getSortedPaths());
                        return null;
                    }
                    if (!this.checkTable(srcTable, newBucketPositions, newSortPositions, this.pGraphContext.getFsopToTable().get(fsOp).getNumBuckets())) {
                        return null;
                    }
                    this.removeReduceSink(rsOp, (TableScanOperator)op /* !! */ , fsOp, srcTable.getSortedPaths());
                    return null;
                }
                if (!(op /* !! */  instanceof SelectOperator)) continue;
                selectOp = (SelectOperator)op /* !! */ ;
                selectDesc = (SelectDesc)selectOp.getConf();
                sourceTableBucketCols.clear();
                sourceTableSortCols.clear();
                i$ = bucketPositions.iterator();
                while (i$.hasNext()) {
                    pos = i$.next();
                    selectColList = selectDesc.getColList().get(pos);
                    if (!(selectColList instanceof ExprNodeColumnDesc)) {
                        return null;
                    }
                    sourceTableBucketCols.add((ExprNodeColumnDesc)selectColList);
                }
                i$ = sortPositions.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block1;
                    pos = (ObjectPair)i$.next();
                    selectColList = selectDesc.getColList().get((Integer)pos.getFirst());
                    if (!(selectColList instanceof ExprNodeColumnDesc)) {
                        return null;
                    }
                    sourceTableSortCols.add((ExprNodeColumnDesc)selectColList);
                }
                break;
            }
        }
    }
}

