/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.util.StringUtils;

public final class RewriteCanApplyCtx
implements NodeProcessorCtx {
    private static final Log LOG = LogFactory.getLog(RewriteCanApplyCtx.class.getName());
    private int aggFuncCnt = 0;
    private boolean queryHasGroupBy = false;
    private boolean aggFuncIsNotCount = false;
    private boolean aggFuncColsFetchException = false;
    private boolean whrClauseColsFetchException = false;
    private boolean selClauseColsFetchException = false;
    private boolean gbyKeysFetchException = false;
    private boolean countOnAllCols = false;
    private boolean countOfOne = false;
    private boolean queryHasMultipleTables = false;
    private Set<String> selectColumnsList = new LinkedHashSet<String>();
    private Set<String> predicateColumnsList = new LinkedHashSet<String>();
    private Set<String> gbKeyNameList = new LinkedHashSet<String>();
    private Set<String> aggFuncColList = new LinkedHashSet<String>();
    private final ParseContext parseContext;
    private String baseTableName;
    private String aggFunction;
    private final Map<String, String> baseToIdxTableMap = new HashMap<String, String>();

    private RewriteCanApplyCtx(ParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public static RewriteCanApplyCtx getInstance(ParseContext parseContext) {
        return new RewriteCanApplyCtx(parseContext);
    }

    void resetCanApplyCtx() {
        this.setAggFuncCnt(0);
        this.setQueryHasGroupBy(false);
        this.setAggFuncIsNotCount(false);
        this.setAggFuncColsFetchException(false);
        this.setWhrClauseColsFetchException(false);
        this.setSelClauseColsFetchException(false);
        this.setGbyKeysFetchException(false);
        this.setCountOnAllCols(false);
        this.setCountOfOne(false);
        this.setQueryHasMultipleTables(false);
        this.selectColumnsList.clear();
        this.predicateColumnsList.clear();
        this.gbKeyNameList.clear();
        this.aggFuncColList.clear();
        this.setBaseTableName("");
        this.setAggFunction("");
    }

    public boolean isQueryHasGroupBy() {
        return this.queryHasGroupBy;
    }

    public void setQueryHasGroupBy(boolean queryHasGroupBy) {
        this.queryHasGroupBy = queryHasGroupBy;
    }

    public boolean isAggFuncIsNotCount() {
        return this.aggFuncIsNotCount;
    }

    public void setAggFuncIsNotCount(boolean aggFuncIsNotCount) {
        this.aggFuncIsNotCount = aggFuncIsNotCount;
    }

    public Map<String, String> getBaseToIdxTableMap() {
        return this.baseToIdxTableMap;
    }

    public void setAggFunction(String aggFunction) {
        this.aggFunction = aggFunction;
    }

    public String getAggFunction() {
        return this.aggFunction;
    }

    public void setAggFuncColsFetchException(boolean aggFuncColsFetchException) {
        this.aggFuncColsFetchException = aggFuncColsFetchException;
    }

    public boolean isAggFuncColsFetchException() {
        return this.aggFuncColsFetchException;
    }

    public void setWhrClauseColsFetchException(boolean whrClauseColsFetchException) {
        this.whrClauseColsFetchException = whrClauseColsFetchException;
    }

    public boolean isWhrClauseColsFetchException() {
        return this.whrClauseColsFetchException;
    }

    public void setSelClauseColsFetchException(boolean selClauseColsFetchException) {
        this.selClauseColsFetchException = selClauseColsFetchException;
    }

    public boolean isSelClauseColsFetchException() {
        return this.selClauseColsFetchException;
    }

    public void setGbyKeysFetchException(boolean gbyKeysFetchException) {
        this.gbyKeysFetchException = gbyKeysFetchException;
    }

    public boolean isGbyKeysFetchException() {
        return this.gbyKeysFetchException;
    }

    public void setCountOnAllCols(boolean countOnAllCols) {
        this.countOnAllCols = countOnAllCols;
    }

    public boolean isCountOnAllCols() {
        return this.countOnAllCols;
    }

    public void setCountOfOne(boolean countOfOne) {
        this.countOfOne = countOfOne;
    }

    public boolean isCountOfOne() {
        return this.countOfOne;
    }

    public void setQueryHasMultipleTables(boolean queryHasMultipleTables) {
        this.queryHasMultipleTables = queryHasMultipleTables;
    }

    public boolean isQueryHasMultipleTables() {
        return this.queryHasMultipleTables;
    }

    public Set<String> getSelectColumnsList() {
        return this.selectColumnsList;
    }

    public void setSelectColumnsList(Set<String> selectColumnsList) {
        this.selectColumnsList = selectColumnsList;
    }

    public Set<String> getPredicateColumnsList() {
        return this.predicateColumnsList;
    }

    public void setPredicateColumnsList(Set<String> predicateColumnsList) {
        this.predicateColumnsList = predicateColumnsList;
    }

    public Set<String> getGbKeyNameList() {
        return this.gbKeyNameList;
    }

    public void setGbKeyNameList(Set<String> gbKeyNameList) {
        this.gbKeyNameList = gbKeyNameList;
    }

    public Set<String> getAggFuncColList() {
        return this.aggFuncColList;
    }

    public void setAggFuncColList(Set<String> aggFuncColList) {
        this.aggFuncColList = aggFuncColList;
    }

    public int getAggFuncCnt() {
        return this.aggFuncCnt;
    }

    public void setAggFuncCnt(int aggFuncCnt) {
        this.aggFuncCnt = aggFuncCnt;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public ParseContext getParseContext() {
        return this.parseContext;
    }

    void populateRewriteVars(Operator<? extends OperatorDesc> topOp) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", FilterOperator.getOperatorName() + "%"), RewriteCanApplyProcFactory.canApplyOnFilterOperator());
        opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + "%"), RewriteCanApplyProcFactory.canApplyOnGroupByOperator());
        opRules.put(new RuleRegExp("R3", SelectOperator.getOperatorName() + "%"), RewriteCanApplyProcFactory.canApplyOnSelectOperator());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, this);
        PreOrderWalker ogw = new PreOrderWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(topOp);
        try {
            ogw.startWalking(topNodes, null);
        }
        catch (SemanticException e) {
            LOG.error("Exception in walking operator tree. Rewrite variables not populated");
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    public void addTable(String baseTableName, String indexTableName) {
        this.baseToIdxTableMap.put(baseTableName, indexTableName);
    }

    public String findBaseTable(String baseTableName) {
        return this.baseToIdxTableMap.get(baseTableName);
    }

    boolean isIndexUsableForQueryBranchRewrite(Index index, Set<String> indexKeyNames) {
        if (!indexKeyNames.containsAll(this.selectColumnsList)) {
            LOG.info("Select list has non index key column :  Cannot use index " + index.getIndexName());
            return false;
        }
        if (!indexKeyNames.containsAll(this.predicateColumnsList)) {
            LOG.info("Predicate column ref list has non index key column :  Cannot use index  " + index.getIndexName());
            return false;
        }
        if (!indexKeyNames.containsAll(this.gbKeyNameList)) {
            LOG.info("Group by key has some non-indexed columns,  Cannot use index  " + index.getIndexName());
            return false;
        }
        if (this.aggFuncColList.size() > 0 && !indexKeyNames.containsAll(this.aggFuncColList)) {
            LOG.info("Agg Func input is not present in index key columns. Currently only agg func on index columns are supported by rewrite optimization");
            return false;
        }
        if (!this.queryHasGroupBy || this.aggFuncCnt != 1 || this.aggFuncIsNotCount) {
            LOG.info("No valid criteria met to apply rewrite.");
            return false;
        }
        this.addTable(this.baseTableName, index.getIndexTableName());
        return true;
    }
}

