/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.OneNullRowInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.NullStructSerDe;

public class MetadataOnlyOptimizer
implements PhysicalPlanResolver {
    private static final Log LOG = LogFactory.getLog(MetadataOnlyOptimizer.class.getName());

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        MetadataOnlyTaskDispatcher disp = new MetadataOnlyTaskDispatcher(pctx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.rootTasks);
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    class MetadataOnlyTaskDispatcher
    implements Dispatcher {
        private final PhysicalContext physicalContext;

        public MetadataOnlyTaskDispatcher(PhysicalContext context) {
            this.physicalContext = context;
        }

        private String getAliasForTableScanOperator(MapredWork work, TableScanOperator tso) {
            for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : work.getAliasToWork().entrySet()) {
                if (entry.getValue() != tso) continue;
                return entry.getKey();
            }
            return null;
        }

        private PartitionDesc changePartitionToMetadataOnly(PartitionDesc desc) {
            if (desc != null) {
                desc.setInputFileFormatClass(OneNullRowInputFormat.class);
                desc.setOutputFileFormatClass(HiveIgnoreKeyTextOutputFormat.class);
                desc.setDeserializerClass(NullStructSerDe.class);
                desc.setSerdeClassName(NullStructSerDe.class.getName());
            }
            return desc;
        }

        private List<String> getPathsForAlias(MapredWork work, String alias) {
            ArrayList<String> paths = new ArrayList<String>();
            for (Map.Entry<String, ArrayList<String>> entry : work.getPathToAliases().entrySet()) {
                if (!entry.getValue().contains(alias)) continue;
                paths.add(entry.getKey());
            }
            return paths;
        }

        private void processAlias(MapredWork work, String alias) {
            PartitionDesc aliasPartn = work.getAliasToPartnInfo().get(alias);
            this.changePartitionToMetadataOnly(aliasPartn);
            List<String> paths = this.getPathsForAlias(work, alias);
            for (String path : paths) {
                PartitionDesc partDesc = work.getPathToPartitionInfo().get(path);
                PartitionDesc newPartition = this.changePartitionToMetadataOnly(partDesc);
                Path fakePath = new Path(this.physicalContext.getContext().getMRTmpFileURI() + newPartition.getTableName() + this.encode(newPartition.getPartSpec()));
                work.getPathToPartitionInfo().remove(path);
                work.getPathToPartitionInfo().put(fakePath.getName(), newPartition);
                ArrayList aliases = (ArrayList)work.getPathToAliases().remove(path);
                work.getPathToAliases().put(fakePath.getName(), aliases);
            }
        }

        private String encode(Map<String, String> partSpec) {
            return partSpec.toString().replaceAll("[:/#\\?]", "_");
        }

        private void convertToMetadataOnlyQuery(MapredWork work, TableScanOperator tso) {
            String alias = this.getAliasForTableScanOperator(work, tso);
            this.processAlias(work, alias);
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task task = (Task)nd;
            Collection<Operator<OperatorDesc>> topOperators = task.getTopOperators();
            if (topOperators.size() == 0) {
                return null;
            }
            LOG.info("Looking for table scans where optimization is applicable");
            ParseContext parseContext = this.physicalContext.getParseContext();
            WalkerCtx walkerCtx = new WalkerCtx();
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new TableScanProcessor());
            opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + "%.*" + FileSinkOperator.getOperatorName() + "%"), new FileSinkProcessor());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, walkerCtx);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            for (Operator<OperatorDesc> workOperator : topOperators) {
                if (!parseContext.getTopOps().values().contains(workOperator)) continue;
                topNodes.add(workOperator);
            }
            if (task.getReducer() != null) {
                topNodes.add(task.getReducer());
            }
            ogw.startWalking(topNodes, null);
            LOG.info(String.format("Found %d metadata only table scans", walkerCtx.getMetadataOnlyTableScans().size()));
            for (TableScanOperator tso : walkerCtx.getMetadataOnlyTableScans()) {
                LOG.info("Metadata only table scan for " + ((TableScanDesc)tso.getConf()).getAlias());
                this.convertToMetadataOnlyQuery((MapredWork)task.getWork(), tso);
            }
            return null;
        }
    }

    private static class FileSinkProcessor
    implements NodeProcessor {
        private FileSinkProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            WalkerCtx walkerCtx = (WalkerCtx)procCtx;
            if (walkerCtx.getMayBeMetadataOnlyTableScans().isEmpty() || walkerCtx.getMayBeMetadataOnlyTableScans().size() > 1) {
                return nd;
            }
            for (Node op : stack) {
                GroupByOperator gby;
                if (!(op instanceof GroupByOperator) || ((GroupByDesc)(gby = (GroupByOperator)op).getConf()).isDistinctLike()) continue;
                walkerCtx.convertNotMetadataOnly();
                return nd;
            }
            walkerCtx.convertMetadataOnly();
            return nd;
        }
    }

    private static class TableScanProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator node = (TableScanOperator)nd;
            WalkerCtx walkerCtx = (WalkerCtx)procCtx;
            if (!(node.getNeededColumnIDs() != null && node.getNeededColumnIDs().size() != 0 || node.getConf() != null && ((TableScanDesc)node.getConf()).getVirtualCols() != null && !((TableScanDesc)node.getConf()).getVirtualCols().isEmpty())) {
                walkerCtx.setMayBeMetadataOnly(node);
            }
            return nd;
        }
    }

    private static class WalkerCtx
    implements NodeProcessorCtx {
        private final HashSet<TableScanOperator> possible = new HashSet();
        private final HashSet<TableScanOperator> success = new HashSet();

        private WalkerCtx() {
        }

        public void setMayBeMetadataOnly(TableScanOperator op) {
            this.possible.add(op);
        }

        public void convertMetadataOnly() {
            this.success.addAll(this.possible);
            this.possible.clear();
        }

        public void convertNotMetadataOnly() {
            this.possible.clear();
            this.success.clear();
        }

        public HashSet<TableScanOperator> getMayBeMetadataOnlyTableScans() {
            return this.possible;
        }

        public HashSet<TableScanOperator> getMetadataOnlyTableScans() {
            return this.success;
        }
    }
}

