/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@WindowFunctionDescription(description=@Description(name="first_value", value="_FUNC_(x)"), supportsWindow=true, pivotResult=false)
public class GenericUDAFFirstValue
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog(GenericUDAFFirstValue.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length > 2) {
            throw new UDFArgumentTypeException(2, "At most 2 arguments expected");
        }
        if (parameters.length > 1 && !parameters[1].equals(TypeInfoFactory.booleanTypeInfo)) {
            throw new UDFArgumentTypeException(1, "second argument must be a boolean expression");
        }
        return this.createEvaluator();
    }

    protected GenericUDAFFirstValueEvaluator createEvaluator() {
        return new GenericUDAFFirstValueEvaluator();
    }

    public static class GenericUDAFFirstValueEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        ObjectInspector outputOI;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for Rank function");
            }
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new FirstValueBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((FirstValueBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            FirstValueBuffer fb = (FirstValueBuffer)agg;
            if (fb.firstRow) {
                fb.firstRow = false;
                if (parameters.length == 2) {
                    fb.skipNulls = PrimitiveObjectInspectorUtils.getBoolean(parameters[1], PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
                }
            }
            if (!fb.valSet) {
                fb.val = ObjectInspectorUtils.copyToStandardObject(parameters[0], this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                if (!fb.skipNulls || fb.val != null) {
                    fb.valSet = true;
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((FirstValueBuffer)agg).val;
        }
    }

    static class FirstValueBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        Object val;
        boolean valSet;
        boolean firstRow;
        boolean skipNulls;

        FirstValueBuffer() {
            this.init();
        }

        void init() {
            this.val = null;
            this.valSet = false;
            this.firstRow = true;
            this.skipNulls = false;
        }
    }
}

