/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLeadLag;

@WindowFunctionDescription(description=@Description(name="lag", value="_FUNC_(expr, amt, default)"), supportsWindow=false, pivotResult=true)
public class GenericUDAFLag
extends GenericUDAFLeadLag {
    static final Log LOG = LogFactory.getLog(GenericUDAFLag.class.getName());

    @Override
    protected String functionName() {
        return "Lag";
    }

    @Override
    protected GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator createLLEvaluator() {
        return new GenericUDAFLagEvaluator();
    }

    static class LagBuffer
    implements GenericUDAFLeadLag.LeadLagBuffer {
        ArrayList<Object> values;
        int lagAmt;
        ArrayList<Object> lagValues;
        int lastRowIdx;

        LagBuffer() {
        }

        @Override
        public void initialize(int lagAmt) {
            this.lagAmt = lagAmt;
            this.lagValues = new ArrayList(lagAmt);
            this.values = new ArrayList();
            this.lastRowIdx = -1;
        }

        @Override
        public void addRow(Object currValue, Object defaultValue) {
            int row = this.lastRowIdx + 1;
            if (row < this.lagAmt) {
                this.lagValues.add(defaultValue);
            }
            this.values.add(currValue);
            ++this.lastRowIdx;
        }

        @Override
        public Object terminate() {
            if (this.values.size() < this.lagAmt) {
                return this.lagValues;
            }
            int lastIdx = this.values.size() - 1;
            for (int i = 0; i < this.lagAmt; ++i) {
                this.values.remove(lastIdx - i);
            }
            this.values.addAll(0, this.lagValues);
            return this.values;
        }
    }

    public static class GenericUDAFLagEvaluator
    extends GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator {
        @Override
        protected GenericUDAFLeadLag.LeadLagBuffer getNewLLBuffer() throws HiveException {
            return new LagBuffer();
        }
    }
}

