/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLeadLag;

@WindowFunctionDescription(description=@Description(name="lead", value="_FUNC_(expr, amt, default)"), supportsWindow=false, pivotResult=true)
public class GenericUDAFLead
extends GenericUDAFLeadLag {
    static final Log LOG = LogFactory.getLog(GenericUDAFLead.class.getName());

    @Override
    protected String functionName() {
        return "Lead";
    }

    @Override
    protected GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator createLLEvaluator() {
        return new GenericUDAFLeadEvaluator();
    }

    static class LeadBuffer
    implements GenericUDAFLeadLag.LeadLagBuffer {
        ArrayList<Object> values;
        int leadAmt;
        Object[] leadWindow;
        int nextPosInWindow;
        int lastRowIdx;

        LeadBuffer() {
        }

        @Override
        public void initialize(int leadAmt) {
            this.leadAmt = leadAmt;
            this.values = new ArrayList();
            this.leadWindow = new Object[leadAmt];
            this.nextPosInWindow = 0;
            this.lastRowIdx = -1;
        }

        @Override
        public void addRow(Object leadExprValue, Object defaultValue) {
            int row = this.lastRowIdx + 1;
            int leadRow = row - this.leadAmt;
            if (leadRow >= 0) {
                this.values.add(leadExprValue);
            }
            this.leadWindow[this.nextPosInWindow] = defaultValue;
            this.nextPosInWindow = (this.nextPosInWindow + 1) % this.leadAmt;
            ++this.lastRowIdx;
        }

        @Override
        public Object terminate() {
            if (this.lastRowIdx < this.leadAmt) {
                this.nextPosInWindow = 0;
            }
            for (int i = 0; i < this.leadAmt; ++i) {
                this.values.add(this.leadWindow[this.nextPosInWindow]);
                this.nextPosInWindow = (this.nextPosInWindow + 1) % this.leadAmt;
            }
            return this.values;
        }
    }

    public static class GenericUDAFLeadEvaluator
    extends GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator {
        @Override
        protected GenericUDAFLeadLag.LeadLagBuffer getNewLLBuffer() throws HiveException {
            return new LeadBuffer();
        }
    }
}

