/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public abstract class TableFunctionResolver {
    TableFunctionEvaluator evaluator;
    PTFDesc ptfDesc;

    public void initialize(HiveConf cfg, PTFDesc ptfDesc, PTFDesc.PartitionedTableFunctionDef tDef) throws SemanticException {
        this.ptfDesc = ptfDesc;
        String partitionClass = HiveConf.getVar(cfg, HiveConf.ConfVars.HIVE_PTF_PARTITION_PERSISTENCE_CLASS);
        int partitionMemSize = HiveConf.getIntVar(cfg, HiveConf.ConfVars.HIVE_PTF_PARTITION_PERSISTENT_SIZE);
        this.evaluator = this.createEvaluator(ptfDesc, tDef);
        this.evaluator.setTransformsRawInput(this.transformsRawInput());
        this.evaluator.setTableDef(tDef);
        this.evaluator.setQueryDef(ptfDesc);
        this.evaluator.setPartitionClass(partitionClass);
        this.evaluator.setPartitionMemSize(partitionMemSize);
    }

    public void initialize(PTFDesc ptfDesc, PTFDesc.PartitionedTableFunctionDef tDef, TableFunctionEvaluator evaluator) throws HiveException {
        this.evaluator = evaluator;
        this.ptfDesc = ptfDesc;
        evaluator.setTableDef(tDef);
        evaluator.setQueryDef(ptfDesc);
    }

    public TableFunctionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public abstract void setupOutputOI() throws SemanticException;

    public abstract ArrayList<String> getOutputColumnNames() throws SemanticException;

    public abstract void initializeOutputOI() throws HiveException;

    public void setupRawInputOI() throws SemanticException {
        if (!this.transformsRawInput()) {
            return;
        }
        throw new SemanticException("Function has map phase, must extend setupMapOI");
    }

    public ArrayList<String> getRawInputColumnNames() throws SemanticException {
        if (!this.transformsRawInput()) {
            return null;
        }
        throw new SemanticException("Function transforms Raw Input; must extend getRawColumnInputNames");
    }

    public void initializeRawInputOI() throws HiveException {
        if (!this.transformsRawInput()) {
            return;
        }
        throw new HiveException("Function has map phase, must extend initializeRawInputOI");
    }

    protected void setRawInputOI(StructObjectInspector rawInputOI) {
        this.evaluator.setRawInputOI(rawInputOI);
    }

    protected void setOutputOI(StructObjectInspector outputOI) {
        this.evaluator.setOutputOI(outputOI);
    }

    public PTFDesc getPtfDesc() {
        return this.ptfDesc;
    }

    public boolean carryForwardNames() {
        return false;
    }

    public abstract boolean transformsRawInput();

    protected abstract TableFunctionEvaluator createEvaluator(PTFDesc var1, PTFDesc.PartitionedTableFunctionDef var2);
}

