/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.apache.hadoop.hive.serde2.avro.ReaderWriterSchemaPair;
import org.apache.hadoop.hive.serde2.avro.SchemaToTypeInfo;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;

class AvroDeserializer {
    private static final Log LOG = LogFactory.getLog(AvroDeserializer.class);
    private List<Object> row;
    private SchemaReEncoder reEncoder;

    AvroDeserializer() {
    }

    public Object deserialize(List<String> columnNames, List<TypeInfo> columnTypes, Writable writable, Schema readerSchema) throws AvroSerdeException {
        if (!(writable instanceof AvroGenericRecordWritable)) {
            throw new AvroSerdeException("Expecting a AvroGenericRecordWritable");
        }
        if (this.row == null || this.row.size() != columnNames.size()) {
            this.row = new ArrayList<Object>(columnNames.size());
        } else {
            this.row.clear();
        }
        AvroGenericRecordWritable recordWritable = (AvroGenericRecordWritable)writable;
        GenericRecord r = recordWritable.getRecord();
        if (!r.getSchema().equals((Object)readerSchema)) {
            LOG.warn("Received different schemas.  Have to re-encode: " + r.getSchema().toString(false));
            if (this.reEncoder == null) {
                this.reEncoder = new SchemaReEncoder();
            }
            r = this.reEncoder.reencode(r, readerSchema);
        }
        this.workerBase(this.row, columnNames, columnTypes, r);
        return this.row;
    }

    private List<Object> workerBase(List<Object> objectRow, List<String> columnNames, List<TypeInfo> columnTypes, GenericRecord record) throws AvroSerdeException {
        for (int i = 0; i < columnNames.size(); ++i) {
            TypeInfo columnType = columnTypes.get(i);
            String columnName = columnNames.get(i);
            Object datum = record.get(columnName);
            Schema datumSchema = record.getSchema().getField(columnName).schema();
            objectRow.add(this.worker(datum, datumSchema, columnType));
        }
        return objectRow;
    }

    private Object worker(Object datum, Schema recordSchema, TypeInfo columnType) throws AvroSerdeException {
        if (AvroSerdeUtils.isNullableType(recordSchema)) {
            return this.deserializeNullableUnion(datum, recordSchema, columnType);
        }
        if (columnType == TypeInfoFactory.stringTypeInfo) {
            return datum.toString();
        }
        switch (columnType.getCategory()) {
            case STRUCT: {
                return this.deserializeStruct((GenericData.Record)datum, (StructTypeInfo)columnType);
            }
            case UNION: {
                return this.deserializeUnion(datum, recordSchema, (UnionTypeInfo)columnType);
            }
            case LIST: {
                return this.deserializeList(datum, recordSchema, (ListTypeInfo)columnType);
            }
            case MAP: {
                return this.deserializeMap(datum, recordSchema, (MapTypeInfo)columnType);
            }
        }
        return datum;
    }

    private Object deserializeNullableUnion(Object datum, Schema recordSchema, TypeInfo columnType) throws AvroSerdeException {
        int tag = GenericData.get().resolveUnion(recordSchema, datum);
        Schema schema = (Schema)recordSchema.getTypes().get(tag);
        if (schema.getType().equals((Object)Schema.Type.NULL)) {
            return null;
        }
        return this.worker(datum, schema, SchemaToTypeInfo.generateTypeInfo(schema));
    }

    private Object deserializeStruct(GenericData.Record datum, StructTypeInfo columnType) throws AvroSerdeException {
        ArrayList<TypeInfo> innerFieldTypes = columnType.getAllStructFieldTypeInfos();
        ArrayList<String> innerFieldNames = columnType.getAllStructFieldNames();
        ArrayList<Object> innerObjectRow = new ArrayList<Object>(innerFieldTypes.size());
        return this.workerBase(innerObjectRow, innerFieldNames, innerFieldTypes, (GenericRecord)datum);
    }

    private Object deserializeUnion(Object datum, Schema recordSchema, UnionTypeInfo columnType) throws AvroSerdeException {
        int tag = GenericData.get().resolveUnion(recordSchema, datum);
        Object desered = this.worker(datum, (Schema)recordSchema.getTypes().get(tag), columnType.getAllUnionObjectTypeInfos().get(tag));
        return new StandardUnionObjectInspector.StandardUnion((byte)tag, desered);
    }

    private Object deserializeList(Object datum, Schema recordSchema, ListTypeInfo columnType) throws AvroSerdeException {
        if (recordSchema.getType().equals((Object)Schema.Type.FIXED)) {
            GenericData.Fixed fixed = (GenericData.Fixed)datum;
            ArrayList<Byte> asList = new ArrayList<Byte>(fixed.bytes().length);
            for (int j = 0; j < fixed.bytes().length; ++j) {
                asList.add(fixed.bytes()[j]);
            }
            return asList;
        }
        if (recordSchema.getType().equals((Object)Schema.Type.BYTES)) {
            ByteBuffer bb = (ByteBuffer)datum;
            ArrayList<Byte> asList = new ArrayList<Byte>(bb.capacity());
            byte[] array = bb.array();
            for (int j = 0; j < array.length; ++j) {
                asList.add(array[j]);
            }
            return asList;
        }
        List listData = (List)datum;
        Schema listSchema = recordSchema.getElementType();
        ArrayList<Object> listContents = new ArrayList<Object>(listData.size());
        for (Object obj : listData) {
            listContents.add(this.worker(obj, listSchema, columnType.getListElementTypeInfo()));
        }
        return listContents;
    }

    private Object deserializeMap(Object datum, Schema mapSchema, MapTypeInfo columnType) throws AvroSerdeException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map mapDatum = (Map)datum;
        Schema valueSchema = mapSchema.getValueType();
        TypeInfo valueTypeInfo = columnType.getMapValueTypeInfo();
        for (Utf8 key : mapDatum.keySet()) {
            Object value = mapDatum.get(key);
            map.put(key.toString(), this.worker(value, valueSchema, valueTypeInfo));
        }
        return map;
    }

    static class SchemaReEncoder {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final GenericDatumWriter<GenericRecord> gdw = new GenericDatumWriter();
        private BinaryDecoder binaryDecoder = null;
        private InstanceCache<ReaderWriterSchemaPair, GenericDatumReader<GenericRecord>> gdrCache = new InstanceCache<ReaderWriterSchemaPair, GenericDatumReader<GenericRecord>>(){

            @Override
            protected GenericDatumReader<GenericRecord> makeInstance(ReaderWriterSchemaPair hv) {
                return new GenericDatumReader(hv.getWriter(), hv.getReader());
            }
        };

        SchemaReEncoder() {
        }

        public GenericRecord reencode(GenericRecord r, Schema readerSchema) throws AvroSerdeException {
            this.baos.reset();
            BinaryEncoder be = EncoderFactory.get().directBinaryEncoder((OutputStream)this.baos, null);
            this.gdw.setSchema(r.getSchema());
            try {
                this.gdw.write((Object)r, (Encoder)be);
                ByteArrayInputStream bais = new ByteArrayInputStream(this.baos.toByteArray());
                this.binaryDecoder = DecoderFactory.defaultFactory().createBinaryDecoder((InputStream)bais, this.binaryDecoder);
                ReaderWriterSchemaPair pair = new ReaderWriterSchemaPair(r.getSchema(), readerSchema);
                GenericDatumReader<GenericRecord> gdr = this.gdrCache.retrieve(pair);
                return (GenericRecord)gdr.read((Object)r, (Decoder)this.binaryDecoder);
            }
            catch (IOException e) {
                throw new AvroSerdeException("Exception trying to re-encode record to new schema", e);
            }
        }
    }
}

