/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public abstract class LazyPrimitive<OI extends ObjectInspector, T extends Writable>
extends LazyObject<OI> {
    private static final Log LOG = LogFactory.getLog(LazyPrimitive.class);
    protected T data;
    protected boolean isNull = false;

    protected LazyPrimitive(OI oi) {
        super(oi);
    }

    protected LazyPrimitive(LazyPrimitive<OI, T> copy) {
        super(copy.oi);
        this.isNull = copy.isNull;
    }

    @Override
    public Object getObject() {
        return this.isNull ? null : this;
    }

    public T getWritableObject() {
        return this.isNull ? null : (T)this.data;
    }

    public String toString() {
        return this.isNull ? null : this.data.toString();
    }

    @Override
    public int hashCode() {
        return this.isNull ? 0 : this.data.hashCode();
    }

    public void logExceptionMessage(ByteArrayRef bytes, int start, int length, String dataType) {
        try {
            String byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
            LOG.debug("Data not in the " + dataType + " data type range so converted to null. Given data is :" + byteData);
        }
        catch (CharacterCodingException e1) {
            LOG.debug("Data not in the " + dataType + " data type range so converted to null.", e1);
        }
    }
}

