/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import com.facebook.presto.hive.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hive.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;

public class LazySimpleStructObjectInspector
extends StructObjectInspector {
    public static final Log LOG = LogFactory.getLog(LazySimpleStructObjectInspector.class.getName());
    protected List<MyField> fields;
    byte separator;
    Text nullSequence;
    boolean lastColumnTakesRest;
    boolean escaped;
    byte escapeChar;

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName(this);
    }

    protected LazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        this.init(structFieldNames, structFieldObjectInspectors, null, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
    }

    public LazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        this.init(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
    }

    protected void init(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        assert (structFieldNames.size() == structFieldObjectInspectors.size());
        assert (structFieldComments == null || structFieldNames.size() == structFieldComments.size());
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.escaped = escaped;
        this.escapeChar = escapeChar;
        this.fields = new ArrayList<MyField>(structFieldNames.size());
        for (int i = 0; i < structFieldNames.size(); ++i) {
            this.fields.add(new MyField(i, structFieldNames.get(i), structFieldObjectInspectors.get(i), structFieldComments == null ? null : structFieldComments.get(i)));
        }
    }

    protected LazySimpleStructObjectInspector(List<StructField> fields, byte separator, Text nullSequence) {
        this.init(fields, separator, nullSequence);
    }

    protected void init(List<StructField> fields, byte separator, Text nullSequence) {
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.fields = new ArrayList<MyField>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            this.fields.add(new MyField(i, fields.get(i).getFieldName(), fields.get(i).getFieldObjectInspector(), fields.get(i).getFieldComment()));
        }
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        LazyStruct struct = (LazyStruct)data;
        MyField f = (MyField)fieldRef;
        int fieldID = f.getFieldID();
        assert (fieldID >= 0 && fieldID < this.fields.size());
        return struct.getField(fieldID);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        LazyStruct struct = (LazyStruct)data;
        return struct.getFieldsAsList();
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Text getNullSequence() {
        return this.nullSequence;
    }

    public boolean getLastColumnTakesRest() {
        return this.lastColumnTakesRest;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }

    protected static class MyField
    implements StructField {
        protected int fieldID;
        protected String fieldName;
        protected ObjectInspector fieldObjectInspector;
        protected String fieldComment;

        public MyField(int fieldID, String fieldName, ObjectInspector fieldObjectInspector) {
            this.fieldID = fieldID;
            this.fieldName = fieldName.toLowerCase();
            this.fieldObjectInspector = fieldObjectInspector;
        }

        public MyField(int fieldID, String fieldName, ObjectInspector fieldObjectInspector, String fieldComment) {
            this(fieldID, fieldName, fieldObjectInspector);
            this.fieldComment = fieldComment;
        }

        public int getFieldID() {
            return this.fieldID;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.fieldObjectInspector;
        }

        @Override
        public String getFieldComment() {
            return this.fieldComment;
        }

        public String toString() {
            return "" + this.fieldID + ":" + this.fieldName;
        }
    }
}

