/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import com.facebook.presto.hive.shaded.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.util.HostUtil;
import org.apache.hadoop.util.Progressable;

public class Hadoop23Shims
extends HadoopShimsSecure {
    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (conf.get("mapreduce.framework.name") != null && conf.get("mapreduce.framework.name").equals("yarn")) {
            LOG.warn("Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return HostUtil.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContextImpl(conf, new TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        return "local".equals(conf.get("mapreduce.framework.name"));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.address");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            conf.set("mapreduce.framework.name", val);
            conf.set("mapreduce.jobtracker.address", val);
        } else {
            conf.set("mapreduce.framework.name", "yarn");
            conf.set("yarn.resourcemanager.address", val);
        }
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("yarn.resourcemanager.webapp.address");
    }

    @Override
    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    @Override
    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    @Override
    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
    }

    @Override
    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;
        private final Configuration conf;

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.conf = conf;
            JobConf jConf = new JobConf(conf);
            jConf.set("yarn.scheduler.capacity.root.queues", "default");
            jConf.set("yarn.scheduler.capacity.root.default.capacity", "100");
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir, null, null, jConf);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            String address = this.conf.get("yarn.resourcemanager.address");
            if (StringUtils.isBlank(address = StringUtils.substringAfterLast(address, ":"))) {
                throw new IllegalArgumentException("Invalid YARN resource manager port.");
            }
            return Integer.parseInt(address);
        }

        @Override
        public void shutdown() throws IOException {
            this.mr.shutdown();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            JobConf jConf = this.mr.createJobConf();
            for (Map.Entry pair : jConf) {
                conf.set((String)pair.getKey(), (String)pair.getValue());
            }
        }
    }
}

