/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Preconditions;

public class TpchHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    public TpchHandleResolver(String connectorId) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof TpchTableHandle && ((TpchTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof TpchColumnHandle;
    }

    public boolean canHandle(Split split) {
        return split instanceof TpchSplit && ((TpchSplit)split).getTableHandle().getConnectorId().equals(this.connectorId);
    }

    public Class<? extends TableHandle> getTableHandleClass() {
        return TpchTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return TpchColumnHandle.class;
    }

    public Class<? extends Split> getSplitClass() {
        return TpchSplit.class;
    }
}

