/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TpchMetadata
extends ReadOnlyConnectorMetadata {
    public static final String TINY_SCHEMA_NAME = "tiny";
    private static final double TINY_SCALE_FACTOR = 0.01;
    private final String connectorId;
    private final Set<String> tableNames;

    public TpchMetadata(String connectorId) {
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (TpchTable tpchTable : TpchTable.getTables()) {
            tableNames.add((Object)tpchTable.getTableName());
        }
        this.tableNames = tableNames.build();
        this.connectorId = connectorId;
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof TpchTableHandle && ((TpchTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public List<String> listSchemaNames() {
        return ImmutableList.of((Object)TINY_SCHEMA_NAME, (Object)"sf1", (Object)"sf100", (Object)"sf300", (Object)"sf1000", (Object)"sf3000", (Object)"sf10000", (Object)"sf30000", (Object)"sf100000");
    }

    public TpchTableHandle getTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        if (!this.tableNames.contains(tableName.getTableName())) {
            return null;
        }
        double scaleFactor = TpchMetadata.schemaNameToScaleFactor(tableName.getSchemaName());
        if (scaleFactor < 0.0) {
            return null;
        }
        return new TpchTableHandle(this.connectorId, tableName.getTableName(), scaleFactor);
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof TpchTableHandle), (Object)"tableHandle is not an instance of TpchTableHandle");
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        TpchTable tpchTable = TpchTable.getTable((String)tpchTableHandle.getTableName());
        String schemaName = TpchMetadata.scaleFactorSchemaName(tpchTableHandle.getScaleFactor());
        return this.getTableMetadata(schemaName, tpchTable);
    }

    private ConnectorTableMetadata getTableMetadata(String schemaName, TpchTable<?> tpchTable) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int ordinalPosition = 0;
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add((Object)new ColumnMetadata(column.getColumnName(), ColumnType.fromNativeType((Class)column.getType()), ordinalPosition++, false));
        }
        SchemaTableName tableName = new SchemaTableName(schemaName, tpchTable.getTableName());
        return new ConnectorTableMetadata(tableName, (List)columns.build());
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        return this.getColumnHandles(tableHandle).get(columnName);
    }

    public ColumnHandle getSampleWeightColumnHandle(TableHandle tableHandle) {
        return null;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (String schemaName : this.getSchemaNames(prefix.getSchemaName())) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                if (prefix.getTableName() != null && !tpchTable.getTableName().equals(prefix.getTableName())) continue;
                ConnectorTableMetadata tableMetadata = this.getTableMetadata(schemaName, tpchTable);
                tableColumns.put((Object)new SchemaTableName(schemaName, tpchTable.getTableName()), (Object)tableMetadata.getColumns());
            }
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableHandle);
        Preconditions.checkArgument((boolean)(columnHandle instanceof TpchColumnHandle), (Object)"columnHandle is not an instance of TpchColumnHandle");
        String columnName = ((TpchColumnHandle)columnHandle).getColumnName();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table %s does not have column %s", tableMetadata.getTable(), columnName));
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : this.getSchemaNames(schemaNameOrNull)) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                builder.add((Object)new SchemaTableName(schemaName, tpchTable.getTableName()));
            }
        }
        return builder.build();
    }

    private List<String> getSchemaNames(String schemaNameOrNull) {
        ImmutableList schemaNames = schemaNameOrNull == null ? this.listSchemaNames() : (TpchMetadata.schemaNameToScaleFactor(schemaNameOrNull) > 0.0 ? ImmutableList.of((Object)schemaNameOrNull) : ImmutableList.of());
        return schemaNames;
    }

    private static String scaleFactorSchemaName(double scaleFactor) {
        return "sf" + scaleFactor;
    }

    private static double schemaNameToScaleFactor(String schemaName) {
        if (TINY_SCHEMA_NAME.equals(schemaName)) {
            return 0.01;
        }
        if (!schemaName.startsWith("sf")) {
            return -1.0;
        }
        try {
            return Double.parseDouble(schemaName.substring(2));
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }
}

