/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.util.DiskChecker;

@InterfaceAudience.Private
class FsVolumeImpl
implements FsVolumeSpi {
    private final FsDatasetImpl dataset;
    private final String storageID;
    private final Map<String, BlockPoolSlice> bpSlices = new HashMap<String, BlockPoolSlice>();
    private final File currentDir;
    private final DF usage;
    private final long reserved;

    FsVolumeImpl(FsDatasetImpl dataset, String storageID, File currentDir, Configuration conf) throws IOException {
        this.dataset = dataset;
        this.storageID = storageID;
        this.reserved = conf.getLong("dfs.datanode.du.reserved", 0L);
        this.currentDir = currentDir;
        File parent = currentDir.getParentFile();
        this.usage = new DF(parent, conf);
    }

    File getCurrentDir() {
        return this.currentDir;
    }

    File getRbwDir(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getRbwDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decDfsUsed(String bpid, long value) {
        FsDatasetImpl fsDatasetImpl = this.dataset;
        synchronized (fsDatasetImpl) {
            BlockPoolSlice bp = this.bpSlices.get(bpid);
            if (bp != null) {
                bp.decDfsUsed(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        FsDatasetImpl fsDatasetImpl = this.dataset;
        synchronized (fsDatasetImpl) {
            for (BlockPoolSlice s : this.bpSlices.values()) {
                dfsUsed += s.getDfsUsed();
            }
        }
        return dfsUsed;
    }

    long getBlockPoolUsed(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getDfsUsed();
    }

    long getCapacity() {
        long remaining = this.usage.getCapacity() - this.reserved;
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public long getAvailable() throws IOException {
        long available;
        long remaining = this.getCapacity() - this.getDfsUsed();
        if (remaining > (available = this.usage.getAvailable())) {
            remaining = available;
        }
        return remaining > 0L ? remaining : 0L;
    }

    long getReserved() {
        return this.reserved;
    }

    BlockPoolSlice getBlockPoolSlice(String bpid) throws IOException {
        BlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp == null) {
            throw new IOException("block pool " + bpid + " is not found");
        }
        return bp;
    }

    @Override
    public String getPath(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getDirectory().getAbsolutePath();
    }

    @Override
    public File getFinalizedDir(String bpid) throws IOException {
        return this.getBlockPoolSlice(bpid).getFinalizedDir();
    }

    @Override
    public String[] getBlockPoolList() {
        return this.bpSlices.keySet().toArray(new String[this.bpSlices.keySet().size()]);
    }

    File createTmpFile(String bpid, Block b) throws IOException {
        return this.getBlockPoolSlice(bpid).createTmpFile(b);
    }

    File createRbwFile(String bpid, Block b) throws IOException {
        return this.getBlockPoolSlice(bpid).createRbwFile(b);
    }

    File addBlock(String bpid, Block b, File f) throws IOException {
        return this.getBlockPoolSlice(bpid).addBlock(b, f);
    }

    void checkDirs() throws DiskChecker.DiskErrorException {
        for (BlockPoolSlice s : this.bpSlices.values()) {
            s.checkDirs();
        }
    }

    void getVolumeMap(ReplicaMap volumeMap) throws IOException {
        for (BlockPoolSlice s : this.bpSlices.values()) {
            s.getVolumeMap(volumeMap);
        }
    }

    void getVolumeMap(String bpid, ReplicaMap volumeMap) throws IOException {
        this.getBlockPoolSlice(bpid).getVolumeMap(volumeMap);
    }

    void addToReplicasMap(String bpid, ReplicaMap volumeMap, File dir, boolean isFinalized) throws IOException {
        BlockPoolSlice bp = this.getBlockPoolSlice(bpid);
        bp.addToReplicasMap(volumeMap, dir, isFinalized);
    }

    void clearPath(String bpid, File f) throws IOException {
        this.getBlockPoolSlice(bpid).clearPath(f);
    }

    public String toString() {
        return this.currentDir.getAbsolutePath();
    }

    void shutdown() {
        Set<Map.Entry<String, BlockPoolSlice>> set = this.bpSlices.entrySet();
        for (Map.Entry<String, BlockPoolSlice> entry : set) {
            entry.getValue().shutdown();
        }
    }

    void addBlockPool(String bpid, Configuration conf) throws IOException {
        File bpdir = new File(this.currentDir, bpid);
        BlockPoolSlice bp = new BlockPoolSlice(bpid, this, bpdir, conf);
        this.bpSlices.put(bpid, bp);
    }

    void shutdownBlockPool(String bpid) {
        BlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp != null) {
            bp.shutdown();
        }
        this.bpSlices.remove(bpid);
    }

    boolean isBPDirEmpty(String bpid) throws IOException {
        File volumeCurrentDir = this.getCurrentDir();
        File bpDir = new File(volumeCurrentDir, bpid);
        File bpCurrentDir = new File(bpDir, "current");
        File finalizedDir = new File(bpCurrentDir, "finalized");
        File rbwDir = new File(bpCurrentDir, "rbw");
        if (finalizedDir.exists() && FileUtil.list(finalizedDir).length != 0) {
            return false;
        }
        return !rbwDir.exists() || FileUtil.list(rbwDir).length == 0;
    }

    void deleteBPDirectories(String bpid, boolean force) throws IOException {
        File volumeCurrentDir = this.getCurrentDir();
        File bpDir = new File(volumeCurrentDir, bpid);
        if (!bpDir.isDirectory()) {
            return;
        }
        File tmpDir = new File(bpDir, "tmp");
        File bpCurrentDir = new File(bpDir, "current");
        File finalizedDir = new File(bpCurrentDir, "finalized");
        File rbwDir = new File(bpCurrentDir, "rbw");
        if (force) {
            FileUtil.fullyDelete(bpDir);
        } else {
            if (!rbwDir.delete()) {
                throw new IOException("Failed to delete " + rbwDir);
            }
            if (!finalizedDir.delete()) {
                throw new IOException("Failed to delete " + finalizedDir);
            }
            FileUtil.fullyDelete(tmpDir);
            for (File f : FileUtil.listFiles(bpCurrentDir)) {
                if (f.delete()) continue;
                throw new IOException("Failed to delete " + f);
            }
            if (!bpCurrentDir.delete()) {
                throw new IOException("Failed to delete " + bpCurrentDir);
            }
            for (File f : FileUtil.listFiles(bpDir)) {
                if (f.delete()) continue;
                throw new IOException("Failed to delete " + f);
            }
            if (!bpDir.delete()) {
                throw new IOException("Failed to delete " + bpDir);
            }
        }
    }

    String getStorageID() {
        return this.storageID;
    }
}

