/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

class EditLogBackupOutputStream
extends EditLogOutputStream {
    static int DEFAULT_BUFFER_SIZE = 256;
    private JournalProtocol backupNode;
    private NamenodeRegistration bnRegistration;
    private NamenodeRegistration nnRegistration;
    private EditsDoubleBuffer doubleBuf;
    private DataOutputBuffer out;

    EditLogBackupOutputStream(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.bnRegistration = bnReg;
        this.nnRegistration = nnReg;
        InetSocketAddress bnAddress = NetUtils.createSocketAddr(this.bnRegistration.getAddress());
        try {
            this.backupNode = NameNodeProxies.createNonHAProxy(new HdfsConfiguration(), bnAddress, JournalProtocol.class, UserGroupInformation.getCurrentUser(), true).getProxy();
        }
        catch (IOException e) {
            Storage.LOG.error("Error connecting to: " + bnAddress, e);
            throw e;
        }
        this.doubleBuf = new EditsDoubleBuffer(DEFAULT_BUFFER_SIZE);
        this.out = new DataOutputBuffer(DEFAULT_BUFFER_SIZE);
    }

    @Override
    public void write(FSEditLogOp op) throws IOException {
        this.doubleBuf.writeOp(op);
    }

    @Override
    public void writeRaw(byte[] bytes, int offset, int length) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void create() throws IOException {
        assert (this.doubleBuf.isFlushed()) : "previous data is not flushed yet";
        this.doubleBuf = new EditsDoubleBuffer(DEFAULT_BUFFER_SIZE);
    }

    @Override
    public void close() throws IOException {
        int size = this.doubleBuf.countBufferedBytes();
        if (size != 0) {
            throw new IOException("BackupEditStream has " + size + " records still to be flushed and cannot be closed.");
        }
        RPC.stopProxy(this.backupNode);
        this.doubleBuf.close();
        this.doubleBuf = null;
    }

    @Override
    public void abort() throws IOException {
        RPC.stopProxy(this.backupNode);
        this.doubleBuf = null;
    }

    @Override
    public void setReadyToFlush() throws IOException {
        this.doubleBuf.setReadyToFlush();
    }

    @Override
    protected void flushAndSync(boolean durable) throws IOException {
        assert (this.out.getLength() == 0) : "Output buffer is not empty";
        int numReadyTxns = this.doubleBuf.countReadyTxns();
        long firstTxToFlush = this.doubleBuf.getFirstReadyTxId();
        this.doubleBuf.flushTo(this.out);
        if (this.out.getLength() > 0) {
            assert (numReadyTxns > 0);
            byte[] data = Arrays.copyOf(this.out.getData(), this.out.getLength());
            this.out.reset();
            assert (this.out.getLength() == 0) : "Output buffer is not empty";
            this.backupNode.journal(this.nnRegistration, firstTxToFlush, numReadyTxns, data);
        }
    }

    NamenodeRegistration getRegistration() {
        return this.bnRegistration;
    }

    void startLogSegment(long txId) throws IOException {
        this.backupNode.startLogSegment(this.nnRegistration, txId);
    }
}

