/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class HadoopKerberosName
extends KerberosName {
    public HadoopKerberosName(String name) {
        super(name);
    }

    public static void setConfiguration(Configuration conf) throws IOException {
        String ruleString = conf.get("hadoop.security.auth_to_local", "DEFAULT");
        HadoopKerberosName.setRules(ruleString);
    }

    public static void main(String[] args) throws Exception {
        HadoopKerberosName.setConfiguration(new Configuration());
        for (String arg : args) {
            HadoopKerberosName name = new HadoopKerberosName(arg);
            System.out.println("Name: " + name + " to " + name.getShortName());
        }
    }

    static {
        block2: {
            try {
                KerberosUtil.getDefaultRealm();
            }
            catch (Exception ke) {
                if (!UserGroupInformation.isSecurityEnabled()) break block2;
                throw new IllegalArgumentException("Can't get Kerberos configuration", ke);
            }
        }
    }
}

