/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;

abstract class BackgroundCacheLoader<K, V>
extends CacheLoader<K, V> {
    private final ListeningExecutorService executor;

    protected BackgroundCacheLoader(ListeningExecutorService executor) {
        this.executor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    public final ListenableFuture<V> reload(final K key, V oldValue) throws Exception {
        return this.executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return BackgroundCacheLoader.this.load(key);
            }
        });
    }
}

