/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.BackgroundCacheLoader;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraPartition;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.ForCassandraSchema;
import com.facebook.presto.cassandra.RetryDriver;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingCassandraSchemaProvider {
    private final String connectorId;
    private final CassandraSession session;
    private final LoadingCache<String, Map<String, String>> schemaNamesCache;
    private final LoadingCache<String, Map<String, String>> tableNamesCache;
    private final LoadingCache<PartitionListKey, List<CassandraPartition>> partitionsCache;
    private final LoadingCache<PartitionListKey, List<CassandraPartition>> partitionsCacheFull;
    private final LoadingCache<SchemaTableName, CassandraTable> tableCache;

    @Inject
    public CachingCassandraSchemaProvider(CassandraConnectorId connectorId, CassandraSession session, @ForCassandraSchema ExecutorService executor, CassandraClientConfig cassandraClientConfig) {
        this(((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString(), session, executor, ((CassandraClientConfig)Preconditions.checkNotNull((Object)cassandraClientConfig, (Object)"cassandraClientConfig is null")).getSchemaCacheTtl(), cassandraClientConfig.getSchemaRefreshInterval());
    }

    public CachingCassandraSchemaProvider(String connectorId, CassandraSession session, ExecutorService executor, Duration cacheTtl, Duration refreshInterval) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.session = (CassandraSession)Preconditions.checkNotNull((Object)session, (Object)"cassandraSession is null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        long expiresAfterWriteMillis = ((Duration)Preconditions.checkNotNull((Object)cacheTtl, (Object)"cacheTtl is null")).toMillis();
        long refreshMills = ((Duration)Preconditions.checkNotNull((Object)refreshInterval, (Object)"refreshInterval is null")).toMillis();
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.schemaNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, Map<String, String>>(listeningExecutor){

            public Map<String, String> load(String key) throws Exception {
                return CachingCassandraSchemaProvider.this.loadAllSchemas();
            }
        });
        this.tableNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, Map<String, String>>(listeningExecutor){

            public Map<String, String> load(String databaseName) throws Exception {
                return CachingCassandraSchemaProvider.this.loadAllTables(databaseName);
            }
        });
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<SchemaTableName, CassandraTable>(listeningExecutor){

            public CassandraTable load(SchemaTableName tableName) throws Exception {
                return CachingCassandraSchemaProvider.this.loadTable(tableName);
            }
        });
        this.partitionsCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<PartitionListKey, List<CassandraPartition>>(listeningExecutor){

            public List<CassandraPartition> load(PartitionListKey key) throws Exception {
                return CachingCassandraSchemaProvider.this.loadPartitions(key);
            }
        });
        this.partitionsCacheFull = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<PartitionListKey, List<CassandraPartition>>(listeningExecutor){

            public List<CassandraPartition> load(PartitionListKey key) throws Exception {
                return CachingCassandraSchemaProvider.this.loadPartitions(key);
            }
        });
    }

    @Managed
    public void flushCache() {
        this.schemaNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.partitionsCache.invalidateAll();
        this.tableCache.invalidateAll();
    }

    public List<String> getAllSchemas() {
        return ImmutableList.copyOf(CachingCassandraSchemaProvider.getCacheValue(this.schemaNamesCache, "", RuntimeException.class).keySet());
    }

    private Map<String, String> loadAllSchemas() throws Exception {
        return RetryDriver.retry().stopOnIllegalExceptions().run("getAllSchemas", new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() {
                return Maps.uniqueIndex(CachingCassandraSchemaProvider.this.session.getAllSchemas(), (Function)CachingCassandraSchemaProvider.toLowerCase());
            }
        });
    }

    public List<String> getAllTables(String databaseName) throws SchemaNotFoundException {
        return ImmutableList.copyOf(CachingCassandraSchemaProvider.getCacheValue(this.tableNamesCache, databaseName, SchemaNotFoundException.class).keySet());
    }

    private Map<String, String> loadAllTables(final String databaseName) throws Exception {
        return RetryDriver.retry().stopOn(NotFoundException.class).stopOnIllegalExceptions().run("getAllTables", new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws SchemaNotFoundException {
                String caseSensitiveDatabaseName = CachingCassandraSchemaProvider.this.getCaseSensitiveSchemaName(databaseName);
                if (caseSensitiveDatabaseName == null) {
                    caseSensitiveDatabaseName = databaseName;
                }
                List<String> tables = CachingCassandraSchemaProvider.this.session.getAllTables(caseSensitiveDatabaseName);
                ImmutableMap nameMap = Maps.uniqueIndex(tables, (Function)CachingCassandraSchemaProvider.toLowerCase());
                if (tables.isEmpty()) {
                    CachingCassandraSchemaProvider.this.session.getSchema(databaseName);
                }
                return nameMap;
            }
        });
    }

    public CassandraTableHandle getTableHandle(SchemaTableName schemaTableName) {
        Preconditions.checkNotNull((Object)schemaTableName, (Object)"schemaTableName is null");
        String schemaName = this.getCaseSensitiveSchemaName(schemaTableName.getSchemaName());
        String tableName = this.getCaseSensitiveTableName(schemaTableName);
        CassandraTableHandle tableHandle = new CassandraTableHandle(this.connectorId, schemaName, tableName);
        return tableHandle;
    }

    private String getCaseSensitiveSchemaName(String caseInsensitiveName) {
        return CachingCassandraSchemaProvider.getCacheValue(this.schemaNamesCache, "", RuntimeException.class).get(caseInsensitiveName.toLowerCase());
    }

    private String getCaseSensitiveTableName(SchemaTableName schemaTableName) {
        return CachingCassandraSchemaProvider.getCacheValue(this.tableNamesCache, schemaTableName.getSchemaName(), SchemaNotFoundException.class).get(schemaTableName.getTableName().toLowerCase());
    }

    public CassandraTable getTable(CassandraTableHandle tableHandle) throws TableNotFoundException {
        return CachingCassandraSchemaProvider.getCacheValue(this.tableCache, tableHandle.getSchemaTableName(), TableNotFoundException.class);
    }

    private CassandraTable loadTable(final SchemaTableName tableName) throws Exception {
        return RetryDriver.retry().stopOn(NotFoundException.class).stopOnIllegalExceptions().run("getTable", new Callable<CassandraTable>(){

            @Override
            public CassandraTable call() throws TableNotFoundException {
                CassandraTable table = CachingCassandraSchemaProvider.this.session.getTable(tableName);
                return table;
            }
        });
    }

    public List<CassandraPartition> getPartitions(CassandraTable table, List<Comparable<?>> filterPrefix) {
        LoadingCache<PartitionListKey, List<CassandraPartition>> cache = filterPrefix.size() == table.getPartitionKeyColumns().size() ? this.partitionsCacheFull : this.partitionsCache;
        PartitionListKey key = new PartitionListKey(table, filterPrefix);
        return CachingCassandraSchemaProvider.getCacheValue(cache, key, RuntimeException.class);
    }

    private List<CassandraPartition> loadPartitions(final PartitionListKey key) throws Exception {
        return RetryDriver.retry().stopOnIllegalExceptions().run("getPartitions", new Callable<List<CassandraPartition>>(){

            @Override
            public List<CassandraPartition> call() {
                return CachingCassandraSchemaProvider.this.session.getPartitions(key.getTable(), key.getFilterPrefix());
            }
        });
    }

    private static <K, V, E extends Exception> V getCacheValue(LoadingCache<K, V> cache, K key, Class<E> exceptionClass) throws E {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)t, exceptionClass);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static Function<String, String> toLowerCase() {
        return new Function<String, String>(){

            public String apply(String str) {
                return str.toLowerCase();
            }
        };
    }

    private static final class PartitionListKey {
        private final CassandraTable table;
        private final List<Comparable<?>> filterPrefix;

        PartitionListKey(CassandraTable table, List<Comparable<?>> filterPrefix) {
            this.table = table;
            this.filterPrefix = ImmutableList.copyOf(filterPrefix);
        }

        public List<Comparable<?>> getFilterPrefix() {
            return this.filterPrefix;
        }

        public CassandraTable getTable() {
            return this.table;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.table, this.filterPrefix});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionListKey other = (PartitionListKey)obj;
            return Objects.equal((Object)this.table, (Object)other.table) && Objects.equal(this.filterPrefix, other.filterPrefix);
        }
    }
}

