/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class CassandraClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private Duration schemaCacheTtl = new Duration(1.0, TimeUnit.HOURS);
    private Duration schemaRefreshInterval = new Duration(2.0, TimeUnit.MINUTES);
    private int maxSchemaRefreshThreads = 10;
    private int limitForPartitionKeySelect = 100000;
    private int fetchSizeForPartitionKeySelect = 20000;
    private int unpartitionedSplits = 1000;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private int fetchSize = 5000;
    private List<String> contactPoints = ImmutableList.of();
    private int nativeProtocolPort = 9042;

    @Min(value=0L)
    public int getLimitForPartitionKeySelect() {
        return this.limitForPartitionKeySelect;
    }

    @Config(value="cassandra.limit-for-partition-key-select")
    public CassandraClientConfig setLimitForPartitionKeySelect(int limitForPartitionKeySelect) {
        this.limitForPartitionKeySelect = limitForPartitionKeySelect;
        return this;
    }

    @Min(value=1L)
    public int getUnpartitionedSplits() {
        return this.unpartitionedSplits;
    }

    @Config(value="cassandra.unpartitioned-splits")
    public CassandraClientConfig setUnpartitionedSplits(int unpartitionedSplits) {
        this.unpartitionedSplits = unpartitionedSplits;
        return this;
    }

    @Min(value=1L)
    public int getMaxSchemaRefreshThreads() {
        return this.maxSchemaRefreshThreads;
    }

    @Config(value="cassandra.max-schema-refresh-threads")
    public CassandraClientConfig setMaxSchemaRefreshThreads(int maxSchemaRefreshThreads) {
        this.maxSchemaRefreshThreads = maxSchemaRefreshThreads;
        return this;
    }

    @NotNull
    public Duration getSchemaCacheTtl() {
        return this.schemaCacheTtl;
    }

    @Config(value="cassandra.schema-cache-ttl")
    public CassandraClientConfig setSchemaCacheTtl(Duration schemaCacheTtl) {
        this.schemaCacheTtl = schemaCacheTtl;
        return this;
    }

    @NotNull
    public Duration getSchemaRefreshInterval() {
        return this.schemaRefreshInterval;
    }

    @Config(value="cassandra.schema-refresh-interval")
    public CassandraClientConfig setSchemaRefreshInterval(Duration schemaRefreshInterval) {
        this.schemaRefreshInterval = schemaRefreshInterval;
        return this;
    }

    @NotNull
    @Size(min=1)
    public List<String> getContactPoints() {
        return this.contactPoints;
    }

    @Config(value="cassandra.contact-points")
    public CassandraClientConfig setContactPoints(String commaSeparatedList) {
        this.contactPoints = SPLITTER.splitToList((CharSequence)commaSeparatedList);
        return this;
    }

    public CassandraClientConfig setContactPoints(String ... contactPoints) {
        this.contactPoints = Arrays.asList(contactPoints);
        return this;
    }

    @Min(value=1L)
    public int getNativeProtocolPort() {
        return this.nativeProtocolPort;
    }

    @Config(value="cassandra.native-protocol-port")
    public CassandraClientConfig setNativeProtocolPort(int nativeProtocolPort) {
        this.nativeProtocolPort = nativeProtocolPort;
        return this;
    }

    @NotNull
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Config(value="cassandra.consistency-level")
    public CassandraClientConfig setConsistencyLevel(ConsistencyLevel level) {
        this.consistencyLevel = level;
        return this;
    }

    @Min(value=1L)
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Config(value="cassandra.fetch-size")
    public CassandraClientConfig setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Min(value=1L)
    public int getFetchSizeForPartitionKeySelect() {
        return this.fetchSizeForPartitionKeySelect;
    }

    @Config(value="cassandra.fetch-size-for-partition-key-select")
    public CassandraClientConfig setFetchSizeForPartitionKeySelect(int fetchSizeForPartitionKeySelect) {
        this.fetchSizeForPartitionKeySelect = fetchSizeForPartitionKeySelect;
        return this;
    }
}

