/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraClientConfig;
import com.facebook.presto.cassandra.CassandraConnector;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraHandleResolver;
import com.facebook.presto.cassandra.CassandraMetadata;
import com.facebook.presto.cassandra.CassandraRecordSetProvider;
import com.facebook.presto.cassandra.CassandraSession;
import com.facebook.presto.cassandra.CassandraSessionFactory;
import com.facebook.presto.cassandra.CassandraSplitManager;
import com.facebook.presto.cassandra.ForCassandraSchema;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class CassandraClientModule
implements Module {
    private final String connectorId;

    public CassandraClientModule(String connectorId) {
        this.connectorId = connectorId;
    }

    public void configure(Binder binder) {
        binder.bind(CassandraConnectorId.class).toInstance((Object)new CassandraConnectorId(this.connectorId));
        binder.bind(CassandraConnector.class).in(Scopes.SINGLETON);
        binder.bind(CassandraMetadata.class).in(Scopes.SINGLETON);
        binder.bind(CassandraSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CassandraRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(CassandraHandleResolver.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(CassandraClientConfig.class);
        binder.bind(CachingCassandraSchemaProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(CachingCassandraSchemaProvider.class).as(ObjectNames.generatedNameOf(CachingCassandraSchemaProvider.class, (String)this.connectorId));
        binder.bind(CassandraSessionFactory.class).in(Scopes.SINGLETON);
    }

    @ForCassandraSchema
    @Singleton
    @Provides
    public ExecutorService createCachingCassandraSchemaExecutor(CassandraConnectorId clientId, CassandraClientConfig cassandraClientConfig) {
        return Executors.newFixedThreadPool(cassandraClientConfig.getMaxSchemaRefreshThreads(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("cassandra-schema-" + clientId + "-%d").build());
    }

    @Singleton
    @Provides
    public CassandraSession createCassandraSession(CassandraConnectorId connectorId, CassandraClientConfig config) {
        CassandraSessionFactory factory = new CassandraSessionFactory(connectorId, config);
        return factory.create();
    }
}

