/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraType;
import com.facebook.presto.cassandra.CassandraTypeWithTypeArguments;
import com.facebook.presto.cassandra.FullCassandraType;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ColumnType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;

public class CassandraColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String name;
    private final int ordinalPosition;
    private final CassandraType cassandraType;
    private final List<CassandraType> typeArguments;
    private final boolean partitionKey;
    private final boolean clusteringKey;

    @JsonCreator
    public CassandraColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="cassandraType") CassandraType cassandraType, @Nullable @JsonProperty(value="typeArguments") List<CassandraType> typeArguments, @JsonProperty(value="partitionKey") boolean partitionKey, @JsonProperty(value="clusteringKey") boolean clusteringKey) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinalPosition is negative");
        this.ordinalPosition = ordinalPosition;
        this.cassandraType = (CassandraType)Preconditions.checkNotNull((Object)cassandraType, (Object)"cassandraType is null");
        int typeArgsSize = cassandraType.getTypeArgumentSize();
        if (typeArgsSize > 0) {
            this.typeArguments = (List)Preconditions.checkNotNull(typeArguments, (Object)"typeArguments is null");
            Preconditions.checkArgument((typeArguments.size() == typeArgsSize ? 1 : 0) != 0, (Object)(cassandraType + " must provide " + typeArgsSize + " type arguments"));
        } else {
            this.typeArguments = null;
        }
        this.partitionKey = partitionKey;
        this.clusteringKey = clusteringKey;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public CassandraType getCassandraType() {
        return this.cassandraType;
    }

    @JsonProperty
    public List<CassandraType> getTypeArguments() {
        return this.typeArguments;
    }

    @JsonProperty
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @JsonProperty
    public boolean isClusteringKey() {
        return this.clusteringKey;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(CassandraCqlUtils.cqlNameToSqlName(this.name), this.cassandraType.getNativeType(), this.ordinalPosition, this.partitionKey);
    }

    public ColumnType getType() {
        return this.cassandraType.getNativeType();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.name, this.ordinalPosition, this.cassandraType, this.typeArguments, this.partitionKey, this.clusteringKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraColumnHandle other = (CassandraColumnHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)other.connectorId) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.ordinalPosition, (Object)other.ordinalPosition) && Objects.equal((Object)this.cassandraType, (Object)other.cassandraType) && Objects.equal(this.typeArguments, other.typeArguments) && Objects.equal((Object)this.partitionKey, (Object)other.partitionKey) && Objects.equal((Object)this.clusteringKey, (Object)other.clusteringKey);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("name", (Object)this.name).add("ordinalPosition", this.ordinalPosition).add("cassandraType", (Object)this.cassandraType);
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            helper.add("typeArguments", this.typeArguments);
        }
        helper.add("partitionKey", this.partitionKey).add("clusteringKey", this.clusteringKey);
        return helper.toString();
    }

    public static Function<ColumnHandle, CassandraColumnHandle> cassandraColumnHandle() {
        return new Function<ColumnHandle, CassandraColumnHandle>(){

            public CassandraColumnHandle apply(ColumnHandle columnHandle) {
                Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
                Preconditions.checkArgument((boolean)(columnHandle instanceof CassandraColumnHandle), (Object)"columnHandle is not an instance of CassandraColumnHandle");
                return (CassandraColumnHandle)columnHandle;
            }
        };
    }

    public static Function<CassandraColumnHandle, ColumnMetadata> columnMetadataGetter() {
        return new Function<CassandraColumnHandle, ColumnMetadata>(){

            public ColumnMetadata apply(CassandraColumnHandle input) {
                return input.getColumnMetadata();
            }
        };
    }

    public static Function<CassandraColumnHandle, ColumnType> nativeTypeGetter() {
        return new Function<CassandraColumnHandle, ColumnType>(){

            public ColumnType apply(CassandraColumnHandle input) {
                return input.getType();
            }
        };
    }

    public static Function<CassandraColumnHandle, FullCassandraType> cassandraFullTypeGetter() {
        return new Function<CassandraColumnHandle, FullCassandraType>(){

            public FullCassandraType apply(CassandraColumnHandle input) {
                if (input.getCassandraType().getTypeArgumentSize() == 0) {
                    return input.getCassandraType();
                }
                return new CassandraTypeWithTypeArguments(input.getCassandraType(), input.getTypeArguments());
            }
        };
    }
}

