/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraClientModule;
import com.facebook.presto.cassandra.CassandraConnector;
import com.facebook.presto.cassandra.RebindSafeMBeanServer;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.airlift.node.NodeModule;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class CassandraConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Map<String, String> optionalConfig;

    public CassandraConnectorFactory(String name, Map<String, String> optionalConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.optionalConfig = (Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null");
    }

    public String getName() {
        return this.name;
    }

    public Connector create(String connectorId, Map<String, String> config) {
        Preconditions.checkNotNull(config, (Object)"config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new NodeModule(), new MBeanModule(), new JsonModule(), new CassandraClientModule(connectorId), new Module(){

                public void configure(Binder binder) {
                    MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                    binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(platformMBeanServer));
                }
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(CassandraConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

