/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraSplit;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.Split;
import com.facebook.presto.spi.TableHandle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class CassandraHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    public CassandraHandleResolver(CassandraConnectorId connectorId) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof CassandraTableHandle && ((CassandraTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof CassandraColumnHandle && ((CassandraColumnHandle)columnHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(Split split) {
        return split instanceof CassandraSplit && ((CassandraSplit)split).getConnectorId().equals(this.connectorId);
    }

    public Class<? extends TableHandle> getTableHandleClass() {
        return CassandraTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return CassandraColumnHandle.class;
    }

    public Class<? extends Split> getSplitClass() {
        return CassandraSplit.class;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }
}

