/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cassandra;

import com.facebook.presto.cassandra.CachingCassandraSchemaProvider;
import com.facebook.presto.cassandra.CassandraColumnHandle;
import com.facebook.presto.cassandra.CassandraConnectorId;
import com.facebook.presto.cassandra.CassandraTable;
import com.facebook.presto.cassandra.CassandraTableHandle;
import com.facebook.presto.cassandra.util.CassandraCqlUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableHandle;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;

public class CassandraMetadata
extends ReadOnlyConnectorMetadata {
    private final String connectorId;
    private final CachingCassandraSchemaProvider schemaProvider;

    @Inject
    public CassandraMetadata(CassandraConnectorId connectorId, CachingCassandraSchemaProvider schemaProvider) {
        this.connectorId = ((CassandraConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.schemaProvider = (CachingCassandraSchemaProvider)Preconditions.checkNotNull((Object)schemaProvider, (Object)"schemaProvider is null");
    }

    public List<String> listSchemaNames() {
        return this.schemaProvider.getAllSchemas();
    }

    public CassandraTableHandle getTableHandle(SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        try {
            CassandraTableHandle tableHandle = this.schemaProvider.getTableHandle(tableName);
            this.schemaProvider.getTable(tableHandle);
            return tableHandle;
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private static SchemaTableName getTableName(TableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraTableHandle), (Object)"tableHandle is not an instance of CassandraTableHandle");
        return ((CassandraTableHandle)tableHandle).getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        SchemaTableName tableName = CassandraMetadata.getTableName(tableHandle);
        return this.getTableMetadata(tableName);
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        CassandraTableHandle tableHandle = this.schemaProvider.getTableHandle(tableName);
        CassandraTable table = this.schemaProvider.getTable(tableHandle);
        ImmutableList columns = ImmutableList.copyOf((Iterable)Iterables.transform(table.getColumns(), CassandraColumnHandle.columnMetadataGetter()));
        return new ConnectorTableMetadata(tableName, (List)columns);
    }

    public List<SchemaTableName> listTables(String schemaNameOrNull) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(schemaNameOrNull)) {
            try {
                for (String tableName : this.schemaProvider.getAllTables(schemaName)) {
                    tableNames.add((Object)new SchemaTableName(schemaName, tableName.toLowerCase()));
                }
            }
            catch (SchemaNotFoundException e) {
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames();
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    public ColumnHandle getColumnHandle(TableHandle tableHandle, String columnName) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnName, (Object)"columnName is null");
        return this.getColumnHandles(tableHandle).get(columnName);
    }

    public ColumnHandle getSampleWeightColumnHandle(TableHandle tableHandle) {
        return null;
    }

    public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
        CassandraTable table = this.schemaProvider.getTable((CassandraTableHandle)tableHandle);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (CassandraColumnHandle columnHandle : table.getColumns()) {
            columnHandles.put((Object)CassandraCqlUtils.cqlNameToSqlName(columnHandle.getName()).toLowerCase(), (Object)columnHandle);
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(tableName).getColumns());
            }
            catch (NotFoundException e) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(TableHandle tableHandle, ColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof CassandraTableHandle), (Object)"tableHandle is not an instance of CassandraTableHandle");
        Preconditions.checkArgument((boolean)(columnHandle instanceof CassandraColumnHandle), (Object)"columnHandle is not an instance of CassandraColumnHandle");
        return ((CassandraColumnHandle)columnHandle).getColumnMetadata();
    }

    public boolean canHandle(TableHandle tableHandle) {
        return tableHandle instanceof CassandraTableHandle && ((CassandraTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("connectorId", (Object)this.connectorId).toString();
    }
}

